/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DateSchemaKey;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DateLayoutTestUtil
extends LayoutTestUtil<DateSchemaKey, NativeSchemaValue> {
    private static final LocalDate[] ALL_EXTREME_VALUES = new LocalDate[]{LocalDate.of(-999999999, 1, 1), LocalDate.of(999999999, 12, 31), LocalDate.of(0, 1, 1), LocalDate.of(0, 1, 2), LocalDate.of(0, 1, 3), LocalDate.of(-1, 12, 31)};

    public static DateValue randomDate(Randoms random) {
        return DateValue.date((LocalDate)random.randomDate());
    }

    DateLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    Layout<DateSchemaKey, NativeSchemaValue> createLayout() {
        return new DateLayout();
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.someUpdatesWithDuplicateValues();
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(DateSchemaKey key1, DateSchemaKey key2) {
        return Values.COMPARATOR.compare(key1.asValue(), key2.asValue());
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        DateValue candidate;
        while (!uniqueCompareValues.add(candidate = DateLayoutTestUtil.randomDate(random.randoms()))) {
        }
        uniqueValues.add((Value)candidate);
        return candidate;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }
}

