/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalTime;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.LocalTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LocalTimeLayoutTestUtil
extends LayoutTestUtil<LocalTimeSchemaKey, NativeSchemaValue> {
    private static final LocalTime[] ALL_EXTREME_VALUES = new LocalTime[]{LocalTime.of(0, 0, 0, 0), LocalTime.of(0, 0, 0, 1), LocalTime.of(0, 0, 0, 2), LocalTime.of(0, 0, 0, 3), LocalTime.of(23, 59, 59, 999999998), LocalTime.of(23, 59, 59, 999999999)};

    public static LocalTimeValue randomLocalTime(Randoms random) {
        return LocalTimeValue.localTime((LocalTime)random.randomLocalTime());
    }

    LocalTimeLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    Layout<LocalTimeSchemaKey, NativeSchemaValue> createLayout() {
        return new LocalTimeLayout();
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.someUpdatesWithDuplicateValues();
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(LocalTimeSchemaKey key1, LocalTimeSchemaKey key2) {
        return Values.COMPARATOR.compare(key1.asValue(), key2.asValue());
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        LocalTimeValue candidate;
        while (!uniqueCompareValues.add(candidate = LocalTimeLayoutTestUtil.randomLocalTime(random.randoms()))) {
        }
        uniqueValues.add((Value)candidate);
        return candidate;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }
}

