/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexAccessorTest;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.NumberSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;

public abstract class NumberSchemaIndexAccessorTest
extends NativeSchemaIndexAccessorTest<NumberSchemaKey, NativeSchemaValue> {
    NumberSchemaIndexAccessor makeAccessorWithSamplingConfig(IndexSamplingConfig samplingConfig) throws IOException {
        return new NumberSchemaIndexAccessor(this.pageCache, (FileSystemAbstraction)this.fs, this.getIndexFile(), this.layout, RecoveryCleanupWorkCollector.immediate(), this.monitor, this.schemaIndexDescriptor, this.indexId, samplingConfig);
    }

    @Test
    public void respectIndexOrder() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates = this.layoutUtil.someUpdates();
        this.processAll(someUpdates);
        Value[] expectedValues = this.layoutUtil.extractValuesFromUpdates(someUpdates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery.RangePredicate supportedQuery = IndexQuery.range((int)0, (Number)Double.NEGATIVE_INFINITY, (boolean)true, (Number)Double.POSITIVE_INFINITY, (boolean)true);
        for (IndexOrder supportedOrder : NumberIndexProvider.CAPABILITY.orderCapability(new ValueCategory[]{ValueCategory.NUMBER})) {
            if (supportedOrder == IndexOrder.ASCENDING) {
                Arrays.sort(expectedValues, Values.COMPARATOR);
            }
            if (supportedOrder == IndexOrder.DESCENDING) {
                Arrays.sort(expectedValues, Values.COMPARATOR.reversed());
            }
            SimpleNodeValueClient client = new SimpleNodeValueClient();
            reader.query((IndexProgressor.NodeValueClient)client, supportedOrder, new IndexQuery[]{supportedQuery});
            int i = 0;
            while (client.next()) {
                Assert.assertEquals((String)"values in order", (Object)expectedValues[i++], (Object)client.values[0]);
            }
            Assert.assertEquals((String)"found all values", (long)i, (long)expectedValues.length);
        }
    }

    @Test
    public void throwForUnsupportedIndexOrder() throws Exception {
        IndexReader reader = this.accessor.newReader();
        IndexOrder unsupportedOrder = IndexOrder.DESCENDING;
        IndexQuery.ExactPredicate unsupportedQuery = IndexQuery.exact((int)0, (Object)"Legolas");
        this.expected.expect(UnsupportedOperationException.class);
        this.expected.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"unsupported order"), (Matcher)CoreMatchers.containsString((String)unsupportedOrder.toString()), (Matcher)CoreMatchers.containsString((String)unsupportedQuery.toString())));
        reader.query((IndexProgressor.NodeValueClient)new SimpleNodeValueClient(), unsupportedOrder, new IndexQuery[]{unsupportedQuery});
    }
}

