/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.Race;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public class RelationshipCreateDeleteIT {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldNotDeadlockOrCrashFromInconsistency() throws Throwable {
        int i;
        Node b;
        Node a;
        try (Transaction tx = this.db.beginTx();){
            a = this.db.createNode();
            b = this.db.createNode();
            a.createRelationshipTo(b, (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        Race race = new Race();
        for (i = 0; i < 30; ++i) {
            race.addContestant(() -> {
                for (int j = 0; j < 10; ++j) {
                    try (Transaction tx = this.db.beginTx();){
                        Node node = this.random.nextBoolean() ? a : b;
                        for (Relationship relationship : node.getRelationships()) {
                            try {
                                relationship.delete();
                            }
                            catch (NotFoundException e) {
                                Assert.assertTrue((boolean)e.getMessage().contains("already deleted"));
                            }
                        }
                        tx.success();
                        continue;
                    }
                }
            });
        }
        for (i = 0; i < 30; ++i) {
            race.addContestant(() -> {
                for (int j = 0; j < 10; ++j) {
                    try (Transaction tx = this.db.beginTx();){
                        boolean order = this.random.nextBoolean();
                        Node start = order ? a : b;
                        Node end = order ? b : a;
                        start.createRelationshipTo(end, (RelationshipType)MyRelTypes.TEST);
                        tx.success();
                        continue;
                    }
                }
            });
        }
        race.go();
    }
}

