/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongFunction;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class ArrayQueueOutOfOrderSequenceTest {
    private final long[] EMPTY_META = new long[]{42L};

    @Test
    public void shouldExposeGapFreeSequenceSingleThreaded() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 10, new long[1]);
        sequence.offer(1L, new long[]{1L});
        this.assertGet((OutOfOrderSequence)sequence, 1L, new long[]{1L});
        sequence.offer(2L, new long[]{2L});
        this.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        sequence.offer(4L, new long[]{3L});
        this.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        sequence.offer(3L, new long[]{4L});
        this.assertGet((OutOfOrderSequence)sequence, 4L, new long[]{3L});
        sequence.offer(5L, new long[]{5L});
        this.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        sequence.offer(10L, new long[]{6L});
        sequence.offer(11L, new long[]{7L});
        sequence.offer(8L, new long[]{8L});
        sequence.offer(9L, new long[]{9L});
        sequence.offer(7L, new long[]{10L});
        this.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        sequence.offer(6L, new long[]{11L});
        this.assertGet((OutOfOrderSequence)sequence, 11L, new long[]{7L});
    }

    @Test
    public void shouldExtendArrayIfNeedBe() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        sequence.offer(3L, new long[]{0L});
        sequence.offer(2L, new long[]{1L});
        sequence.offer(5L, new long[]{2L});
        sequence.offer(4L, new long[]{3L});
        sequence.offer(6L, new long[]{4L});
        sequence.offer(1L, new long[]{5L});
        this.assertGet((OutOfOrderSequence)sequence, 6L, new long[]{4L});
    }

    @Test
    public void shouldDealWithThisScenario() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        Assert.assertTrue((boolean)sequence.offer(1L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(3L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(4L, new long[]{0L}));
        Assert.assertTrue((boolean)sequence.offer(2L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(6L, new long[]{0L}));
        Assert.assertTrue((boolean)sequence.offer(5L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(8L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(9L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(10L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(11L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(12L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(13L, new long[]{0L}));
        Assert.assertFalse((boolean)sequence.offer(14L, new long[]{0L}));
        Assert.assertTrue((boolean)sequence.offer(7L, new long[]{0L}));
        this.assertGet((OutOfOrderSequence)sequence, 14L, new long[]{0L});
    }

    /*
     * Exception decompiling
     */
    @Test
    public void shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void highestEverSeenTest() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, this.EMPTY_META);
        Assert.assertEquals((long)0L, (long)sequence.highestEverSeen());
        sequence.offer(1L, this.EMPTY_META);
        Assert.assertEquals((long)1L, (long)sequence.highestEverSeen());
        sequence.offer(42L, this.EMPTY_META);
        Assert.assertEquals((long)42L, (long)sequence.highestEverSeen());
    }

    @Test
    public void shouldBeAbleToTimeoutWaitingForNumber() throws Exception {
        long timeout = 10L;
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(3L, 5, this.EMPTY_META);
        long startTime = System.currentTimeMillis();
        try {
            sequence.await(4L, timeout);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        Assert.assertThat((Object)(endTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void shouldBeAbleToReturnImmediatelyWhenNumberAvailable() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(4L, 5, this.EMPTY_META);
        sequence.await(4L, 0L);
    }

    @Test
    public void shouldBeNotifiedWhenNumberAvailable() throws Exception {
        Semaphore done = new Semaphore(0);
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(3L, 5, this.EMPTY_META);
        Thread numberWaiter = new Thread(() -> ArrayQueueOutOfOrderSequenceTest.lambda$shouldBeNotifiedWhenNumberAvailable$4((OutOfOrderSequence)sequence, done));
        numberWaiter.start();
        Assert.assertFalse((boolean)done.tryAcquire(10L, TimeUnit.MILLISECONDS));
        sequence.offer(4L, this.EMPTY_META);
        Assert.assertFalse((boolean)done.tryAcquire(10L, TimeUnit.MILLISECONDS));
        sequence.offer(5L, this.EMPTY_META);
        Assert.assertTrue((boolean)done.tryAcquire(10000L, TimeUnit.MILLISECONDS));
        numberWaiter.join();
    }

    private void assertGet(OutOfOrderSequence sequence, long number, long[] meta) {
        long[] data = sequence.get();
        long[] expected = new long[meta.length + 1];
        expected[0] = number;
        System.arraycopy(meta, 0, expected, 1, meta.length);
        Assert.assertArrayEquals((long[])expected, (long[])data);
    }

    private static /* synthetic */ void lambda$shouldBeNotifiedWhenNumberAvailable$4(OutOfOrderSequence sequence, Semaphore done) {
        try {
            sequence.await(5L, 60000L);
        }
        catch (InterruptedException | TimeoutException e) {
            Assert.fail((String)"Should not have thrown");
        }
        done.release();
    }

    private static /* synthetic */ void lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$3(OutOfOrderSequence sequence, LongFunction metaFunction) {
        long[] highest = sequence.get();
        long[] expectedMeta = (long[])metaFunction.apply(highest[0]);
        Assert.assertArrayEquals((long[])expectedMeta, (long[])Arrays.copyOfRange(highest, 1, highest.length));
    }

    private static /* synthetic */ void lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$2(AtomicLong numberSource, OutOfOrderSequence sequence, LongFunction metaFunction) {
        long number = numberSource.incrementAndGet();
        sequence.offer(number, (long[])metaFunction.apply(number));
    }

    private static /* synthetic */ boolean lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$1(AtomicLong numberSource) {
        return numberSource.get() > 10000000L;
    }
}

