/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestStoreAccess {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private final Monitors monitors = new Monitors();
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Test
    public void openingThroughStoreAccessShouldNotTriggerRecovery() throws Throwable {
        try (EphemeralFileSystemAbstraction snapshot = this.produceUncleanStore();){
            Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean((FileSystemAbstraction)snapshot));
            File messages = new File(this.storeDir, "debug.log");
            snapshot.deleteFile(messages);
            PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)snapshot);
            new StoreAccess((FileSystemAbstraction)snapshot, pageCache, this.storeDir, Config.defaults()).initialize().close();
            Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean((FileSystemAbstraction)snapshot));
        }
    }

    private EphemeralFileSystemAbstraction produceUncleanStore() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(this.storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        EphemeralFileSystemAbstraction snapshot = ((EphemeralFileSystemAbstraction)this.fs.get()).snapshot();
        db.shutdown();
        return snapshot;
    }

    private boolean isUnclean(FileSystemAbstraction fileSystem) throws IOException {
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystem);
        RecoveryRequiredChecker requiredChecker = new RecoveryRequiredChecker(fileSystem, pageCache, Config.defaults(), this.monitors);
        return requiredChecker.isRecoveryRequiredAt(this.storeDir);
    }
}

