/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.storemigration.participant.NativeLabelScanStoreMigrator;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class NativeLabelScanStoreMigratorTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    private File storeDir;
    private File nativeLabelIndex;
    private File migrationDir;
    private File luceneLabelScanStore;
    private final ProgressReporter progressReporter = (ProgressReporter)Mockito.mock(ProgressReporter.class);
    private FileSystemAbstraction fileSystem;
    private PageCache pageCache;
    private NativeLabelScanStoreMigrator indexMigrator;

    @Before
    public void setUp() throws Exception {
        this.storeDir = this.testDirectory.directory("store");
        this.nativeLabelIndex = new File(this.storeDir, "neostore.labelscanstore.db");
        this.migrationDir = this.testDirectory.directory("migrationDir");
        this.luceneLabelScanStore = this.storeDir.toPath().resolve(Paths.get("schema", "label", "lucene")).toFile();
        this.fileSystem = this.fileSystemRule.get();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule);
        this.indexMigrator = new NativeLabelScanStoreMigrator(this.fileSystem, this.pageCache, Config.defaults());
        this.fileSystem.mkdirs(this.luceneLabelScanStore);
    }

    @Test
    public void skipMigrationIfNativeIndexExist() throws Exception {
        ByteBuffer sourceBuffer = this.writeFile(this.nativeLabelIndex, new byte[]{1, 2, 3});
        this.indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressReporter, StandardV3_2.STORE_VERSION, StandardV3_2.STORE_VERSION);
        this.indexMigrator.moveMigratedFiles(this.migrationDir, this.storeDir, StandardV3_2.STORE_VERSION, StandardV3_2.STORE_VERSION);
        ByteBuffer resultBuffer = this.readFileContent(this.nativeLabelIndex, 3);
        Assert.assertEquals((Object)sourceBuffer, (Object)resultBuffer);
        Assert.assertTrue((boolean)this.fileSystem.fileExists(this.luceneLabelScanStore));
    }

    @Test(expected=InvalidIdGeneratorException.class)
    public void failMigrationWhenNodeIdFileIsBroken() throws Exception {
        this.prepareEmpty23Database();
        File nodeIdFile = new File(this.storeDir, StoreFile.NODE_STORE.storeFileName() + ".id");
        this.writeFile(nodeIdFile, new byte[]{1, 2, 3});
        this.indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressReporter, StandardV3_2.STORE_VERSION, StandardV3_2.STORE_VERSION);
    }

    @Test
    public void clearMigrationDirFromAnyLabelScanStoreBeforeMigrating() throws Exception {
        this.prepareEmpty23Database();
        this.initializeNativeLabelScanStoreWithContent(this.migrationDir);
        File toBeDeleted = new File(this.migrationDir, "neostore.labelscanstore.db");
        Assert.assertTrue((boolean)this.fileSystem.fileExists(toBeDeleted));
        this.indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressReporter, StandardV3_2.STORE_VERSION, StandardV3_2.STORE_VERSION);
        this.assertNoContentInNativeLabelScanStore(this.migrationDir);
    }

    @Test
    public void luceneLabelIndexRemovedAfterSuccessfulMigration() throws IOException {
        this.prepareEmpty23Database();
        this.indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressReporter, StandardV2_3.STORE_VERSION, StandardV3_2.STORE_VERSION);
        this.indexMigrator.moveMigratedFiles(this.migrationDir, this.storeDir, StandardV2_3.STORE_VERSION, StandardV3_2.STORE_VERSION);
        Assert.assertFalse((boolean)this.fileSystem.fileExists(this.luceneLabelScanStore));
    }

    @Test
    public void moveCreatedNativeLabelIndexBackToStoreDirectory() throws IOException {
        this.prepareEmpty23Database();
        this.indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressReporter, StandardV2_3.STORE_VERSION, StandardV3_2.STORE_VERSION);
        File migrationNativeIndex = new File(this.migrationDir, "neostore.labelscanstore.db");
        ByteBuffer migratedFileContent = this.writeFile(migrationNativeIndex, new byte[]{5, 4, 3, 2, 1});
        this.indexMigrator.moveMigratedFiles(this.migrationDir, this.storeDir, StandardV2_3.STORE_VERSION, StandardV3_2.STORE_VERSION);
        ByteBuffer movedNativeIndex = this.readFileContent(this.nativeLabelIndex, 5);
        Assert.assertEquals((Object)migratedFileContent, (Object)movedNativeIndex);
    }

    @Test
    public void populateNativeLabelScanIndexDuringMigration() throws IOException {
        this.prepare34DatabaseWithNodes();
        this.indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressReporter, StandardV3_4.STORE_VERSION, StandardV3_4.STORE_VERSION);
        this.indexMigrator.moveMigratedFiles(this.migrationDir, this.storeDir, StandardV2_3.STORE_VERSION, StandardV3_2.STORE_VERSION);
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            NativeLabelScanStore labelScanStore = this.getNativeLabelScanStore(this.storeDir, true);
            lifespan.add((Lifecycle)labelScanStore);
            for (int labelId = 0; labelId < 10; ++labelId) {
                try (LabelScanReader labelScanReader = labelScanStore.newReader();){
                    int nodeCount = PrimitiveLongCollections.count((PrimitiveLongIterator)labelScanReader.nodesWithLabel(labelId));
                    Assert.assertEquals((String)String.format("Expected to see only one node for label %d but was %d.", labelId, nodeCount), (long)1L, (long)nodeCount);
                    continue;
                }
            }
        }
    }

    @Test
    public void reportProgressOnNativeIndexPopulation() throws IOException {
        this.prepare34DatabaseWithNodes();
        this.indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressReporter, StandardV3_4.STORE_VERSION, StandardV3_4.STORE_VERSION);
        this.indexMigrator.moveMigratedFiles(this.migrationDir, this.storeDir, StandardV2_3.STORE_VERSION, StandardV3_2.STORE_VERSION);
        ((ProgressReporter)Mockito.verify((Object)this.progressReporter)).start(10L);
        ((ProgressReporter)Mockito.verify((Object)this.progressReporter, (VerificationMode)Mockito.times((int)10))).progress(1L);
    }

    private NativeLabelScanStore getNativeLabelScanStore(File dir, boolean readOnly) {
        return new NativeLabelScanStore(this.pageCache, this.fileSystem, dir, FullStoreChangeStream.EMPTY, readOnly, new Monitors(), RecoveryCleanupWorkCollector.ignore());
    }

    private void initializeNativeLabelScanStoreWithContent(File dir) throws IOException {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            NativeLabelScanStore nativeLabelScanStore = this.getNativeLabelScanStore(dir, false);
            lifespan.add((Lifecycle)nativeLabelScanStore);
            try (LabelScanWriter labelScanWriter = nativeLabelScanStore.newWriter();){
                labelScanWriter.write(NodeLabelUpdate.labelChanges((long)1L, (long[])new long[0], (long[])new long[]{1L}));
            }
            nativeLabelScanStore.force(IOLimiter.unlimited());
        }
    }

    private void assertNoContentInNativeLabelScanStore(File dir) {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            NativeLabelScanStore nativeLabelScanStore = this.getNativeLabelScanStore(dir, true);
            lifespan.add((Lifecycle)nativeLabelScanStore);
            try (LabelScanReader labelScanReader = nativeLabelScanStore.newReader();){
                int count = PrimitiveLongCollections.count((PrimitiveLongIterator)labelScanReader.nodesWithLabel(1));
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    private ByteBuffer writeFile(File file, byte[] content) throws IOException {
        ByteBuffer sourceBuffer = ByteBuffer.wrap(content);
        this.storeFileContent(file, sourceBuffer);
        sourceBuffer.flip();
        return sourceBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare34DatabaseWithNodes() {
        GraphDatabaseService embeddedDatabase = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDir);
        try (Transaction transaction = embeddedDatabase.beginTx();){
            for (int i = 0; i < 10; ++i) {
                embeddedDatabase.createNode(new Label[]{Label.label((String)("label" + i))});
            }
            transaction.success();
        }
        finally {
            embeddedDatabase.shutdown();
        }
        this.fileSystem.deleteFile(this.nativeLabelIndex);
    }

    private void prepareEmpty23Database() throws IOException {
        new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDir).shutdown();
        this.fileSystem.deleteFile(this.nativeLabelIndex);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)new File(this.storeDir, "neostore"), (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)StandardV2_3.STORE_VERSION));
    }

    private ByteBuffer readFileContent(File nativeLabelIndex, int length) throws IOException {
        try (StoreChannel storeChannel = this.fileSystem.open(nativeLabelIndex, OpenMode.READ);){
            ByteBuffer readBuffer = ByteBuffer.allocate(length);
            while (readBuffer.hasRemaining() && storeChannel.read(readBuffer) > 0) {
            }
            readBuffer.flip();
            ByteBuffer byteBuffer = readBuffer;
            return byteBuffer;
        }
    }

    private void storeFileContent(File file, ByteBuffer sourceBuffer) throws IOException {
        try (StoreChannel storeChannel = this.fileSystem.create(file);){
            storeChannel.writeAll(sourceBuffer);
        }
    }
}

