/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexActivator;
import org.neo4j.kernel.impl.transaction.command.IndexBatchTransactionApplier;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class IndexBatchTransactionApplierTest {
    @Test
    public void shouldProvideLabelScanStoreUpdatesSortedByNodeId() throws Exception {
        IndexingService indexing = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)indexing.convertToIndexUpdates((NodeUpdates)ArgumentMatchers.any())).thenAnswer(o -> Iterables.empty());
        OrderVerifyingLabelScanWriter writer = new OrderVerifyingLabelScanWriter(10L, 15L, 20L);
        WorkSync labelScanSync = (WorkSync)Mockito.spy((Object)new WorkSync(this.singletonProvider(writer)));
        WorkSync indexUpdatesSync = new WorkSync((Object)indexing);
        TransactionToApply tx = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
        try (IndexBatchTransactionApplier applier = new IndexBatchTransactionApplier(indexing, labelScanSync, indexUpdatesSync, (NodeStore)Mockito.mock(NodeStore.class), new PropertyPhysicalToLogicalConverter(propertyStore), new IndexActivator(indexing));
             TransactionApplier txApplier = applier.startTx((CommandsToApply)tx);){
            txApplier.visitNodeCommand(this.node(15L));
            txApplier.visitNodeCommand(this.node(20L));
            txApplier.visitNodeCommand(this.node(10L));
        }
        ((WorkSync)Mockito.verify((Object)labelScanSync)).applyAsync((Work)ArgumentMatchers.any());
    }

    @Test
    public void shouldRegisterIndexesToActivateIntoTheActivator() throws Exception {
        IndexingService indexing = (IndexingService)Mockito.mock(IndexingService.class);
        OrderVerifyingLabelScanWriter writer = new OrderVerifyingLabelScanWriter(10L, 15L, 20L);
        WorkSync labelScanSync = (WorkSync)Mockito.spy((Object)new WorkSync(this.singletonProvider(writer)));
        WorkSync indexUpdatesSync = new WorkSync((Object)indexing);
        PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
        TransactionToApply tx = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        IndexActivator indexActivator = new IndexActivator(indexing);
        long indexId1 = 1L;
        long indexId2 = 2L;
        long indexId3 = 3L;
        long constraintId1 = 10L;
        long constraintId2 = 11L;
        long constraintId3 = 12L;
        IndexProvider.Descriptor providerDescriptor = new IndexProvider.Descriptor("index-key", "v1");
        IndexRule rule1 = IndexRule.constraintIndexRule((long)indexId1, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1}), (IndexProvider.Descriptor)providerDescriptor, (Long)constraintId1);
        IndexRule rule2 = IndexRule.constraintIndexRule((long)indexId2, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{1}), (IndexProvider.Descriptor)providerDescriptor, (Long)constraintId2);
        IndexRule rule3 = IndexRule.constraintIndexRule((long)indexId3, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)3, (int[])new int[]{1}), (IndexProvider.Descriptor)providerDescriptor, (Long)constraintId3);
        try (IndexBatchTransactionApplier applier = new IndexBatchTransactionApplier(indexing, labelScanSync, indexUpdatesSync, (NodeStore)Mockito.mock(NodeStore.class), new PropertyPhysicalToLogicalConverter(propertyStore), indexActivator);
             TransactionApplier txApplier = applier.startTx((CommandsToApply)tx);){
            txApplier.visitSchemaRuleCommand(new Command.SchemaRuleCommand(Collections.emptyList(), this.asRecords(rule1, true), (SchemaRule)rule1));
            txApplier.visitSchemaRuleCommand(new Command.SchemaRuleCommand(Collections.emptyList(), this.asRecords(rule2, true), (SchemaRule)rule2));
            txApplier.visitSchemaRuleCommand(new Command.SchemaRuleCommand(Collections.emptyList(), this.asRecords(rule3, true), (SchemaRule)rule3));
            txApplier.visitSchemaRuleCommand(new Command.SchemaRuleCommand(this.asRecords(rule2, true), this.asRecords(rule2, false), (SchemaRule)rule2));
        }
        ((IndexingService)Mockito.verify((Object)indexing)).dropIndex(rule2);
        indexActivator.close();
        ((IndexingService)Mockito.verify((Object)indexing)).activateIndex(indexId1);
        ((IndexingService)Mockito.verify((Object)indexing)).activateIndex(indexId3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexing});
    }

    private Collection<DynamicRecord> asRecords(IndexRule rule, boolean inUse) {
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        DynamicRecord dynamicRecord = new DynamicRecord(rule.getId());
        dynamicRecord.setInUse(inUse);
        records.add(dynamicRecord);
        return records;
    }

    private Supplier<LabelScanWriter> singletonProvider(LabelScanWriter writer) {
        return () -> writer;
    }

    private Command.NodeCommand node(long nodeId) {
        NodeRecord after = new NodeRecord(nodeId, true, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), 0L);
        NodeLabelsField.parseLabelsField((NodeRecord)after).add(1L, null, null);
        return new Command.NodeCommand(new NodeRecord(nodeId), after);
    }

    private static class OrderVerifyingLabelScanWriter
    implements LabelScanWriter {
        private final long[] expectedNodeIds;
        private int cursor;

        OrderVerifyingLabelScanWriter(long ... expectedNodeIds) {
            this.expectedNodeIds = expectedNodeIds;
        }

        public void write(NodeLabelUpdate update) {
            Assert.assertEquals((long)this.expectedNodeIds[this.cursor], (long)update.getNodeId());
            ++this.cursor;
        }

        public void close() {
            Assert.assertEquals((long)this.cursor, (long)this.expectedNodeIds.length);
        }
    }
}

