/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.kvstore.LockWrapper;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CheckPointerConstraintCreationDeadlockIT {
    private static final Label LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    @Rule
    public final VerboseTimeout timeout = VerboseTimeout.builder().withTimeout(30L, TimeUnit.SECONDS).build();
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("T2");
    @Rule
    public final OtherThreadRule<Void> t3 = new OtherThreadRule("T3");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotDeadlock() throws Exception {
        List<TransactionRepresentation> transactions = CheckPointerConstraintCreationDeadlockIT.createConstraintCreatingTransactions();
        Monitors monitors = new Monitors();
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setMonitors(monitors).newImpermanentDatabase();
        final Barrier.Control controller = new Barrier.Control();
        boolean success = false;
        try {
            IndexingService.MonitorAdapter monitor = new IndexingService.MonitorAdapter(){

                public void indexPopulationScanComplete() {
                    controller.reached();
                }
            };
            monitors.addMonitorListener((Object)monitor, new String[0]);
            Future<Object> applier = this.applyInT2(db, transactions);
            controller.await();
            Future checkPointer = this.t3.execute(state -> ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("MANUAL")));
            try {
                this.t3.get().waitUntilWaiting(details -> details.isAt(LockWrapper.class, "writeLock"));
            }
            catch (IllegalStateException e) {
                checkPointer.get();
            }
            controller.release();
            applier.get(10L, TimeUnit.SECONDS);
            checkPointer.get(10L, TimeUnit.SECONDS);
            success = true;
            try (Transaction tx = db.beginTx();){
                ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)db.schema().getConstraints(LABEL));
                Assert.assertEquals((Object)KEY, (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                tx.success();
            }
            this.createNode(db, "A");
            try {
                this.createNode(db, "A");
                Assert.fail((String)"Should have failed");
            }
            catch (ConstraintViolationException constraintViolationException) {
                // empty catch block
            }
        }
        finally {
            if (!success) {
                this.t2.interrupt();
                this.t3.interrupt();
            }
            db.shutdown();
        }
    }

    private void createNode(GraphDatabaseAPI db, String name) {
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)name);
            tx.success();
        }
    }

    private Future<Object> applyInT2(GraphDatabaseAPI db, List<TransactionRepresentation> transactions) {
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)db.getDependencyResolver().resolveDependency(TransactionCommitProcess.class);
        return this.t2.execute(state -> {
            transactions.forEach(tx -> {
                try {
                    commitProcess.commit(new TransactionToApply(tx), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
                }
                catch (TransactionFailureException e) {
                    throw new RuntimeException(e);
                }
            });
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TransactionRepresentation> createConstraintCreatingTransactions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            try (Transaction tx = db.beginTx();){
                db.schema().constraintFor(LABEL).assertPropertyIsUnique(KEY).create();
                tx.success();
            }
            LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
            ArrayList<TransactionRepresentation> result = new ArrayList<TransactionRepresentation>();
            try (TransactionCursor cursor = txStore.getTransactions(2L);){
                while (cursor.next()) {
                    result.add(((CommittedTransactionRepresentation)cursor.get()).getTransactionRepresentation());
                }
            }
            ArrayList<TransactionRepresentation> arrayList = result;
            return arrayList;
        }
        finally {
            db.shutdown();
        }
    }
}

