/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LogFilesBuilderTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private File storeDirectory;
    private DefaultFileSystemAbstraction fileSystem;

    @Before
    public void setUp() {
        this.storeDirectory = this.testDirectory.directory();
        this.fileSystem = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
    }

    @Test
    public void buildActiveFilesOnlyContext() throws IOException {
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystem);
        TransactionLogFilesContext context = LogFilesBuilder.activeFilesBuilder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem, (PageCache)pageCache).buildContext();
        Assert.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assert.assertNotNull((Object)context.getLogEntryReader());
        Assert.assertSame((Object)LogFileCreationMonitor.NO_MONITOR, (Object)context.getLogFileCreationMonitor());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)context.getRotationThreshold().get());
        Assert.assertEquals((long)0L, (long)context.getLastCommittedTransactionId());
        Assert.assertEquals((long)0L, (long)context.getLogVersionRepository().getCurrentLogVersion());
    }

    @Test
    public void buildFilesBasedContext() throws IOException {
        TransactionLogFilesContext context = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).buildContext();
        Assert.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assert.assertSame((Object)LogFileCreationMonitor.NO_MONITOR, (Object)context.getLogFileCreationMonitor());
    }

    @Test
    public void buildDefaultContext() throws IOException {
        TransactionLogFilesContext context = LogFilesBuilder.builder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository(2L)).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).buildContext();
        Assert.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assert.assertNotNull((Object)context.getLogEntryReader());
        Assert.assertSame((Object)LogFileCreationMonitor.NO_MONITOR, (Object)context.getLogFileCreationMonitor());
        Assert.assertEquals((long)ByteUnit.mebiBytes((long)250L), (long)context.getRotationThreshold().get());
        Assert.assertEquals((long)1L, (long)context.getLastCommittedTransactionId());
        Assert.assertEquals((long)2L, (long)context.getLogVersionRepository().getCurrentLogVersion());
    }

    @Test
    public void buildDefaultContextWithDependencies() throws IOException {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository(2L);
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)logVersionRepository);
        dependencies.satisfyDependency((Object)transactionIdStore);
        TransactionLogFilesContext context = LogFilesBuilder.builder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withDependencies(dependencies).buildContext();
        Assert.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assert.assertNotNull((Object)context.getLogEntryReader());
        Assert.assertSame((Object)LogFileCreationMonitor.NO_MONITOR, (Object)context.getLogFileCreationMonitor());
        Assert.assertEquals((long)ByteUnit.mebiBytes((long)250L), (long)context.getRotationThreshold().get());
        Assert.assertEquals((long)1L, (long)context.getLastCommittedTransactionId());
        Assert.assertEquals((long)2L, (long)context.getLogVersionRepository().getCurrentLogVersion());
    }

    @Test
    public void buildContextWithCustomLogFilesLocations() throws Throwable {
        String customLogLocation = "customLogLocation";
        Config customLogLocationConfig = Config.defaults((Setting)GraphDatabaseSettings.logical_logs_location, (String)customLogLocation);
        LogFiles logFiles = LogFilesBuilder.builder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withConfig(customLogLocationConfig).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).build();
        logFiles.init();
        logFiles.start();
        Assert.assertEquals((Object)new File(this.storeDirectory, customLogLocation), (Object)logFiles.getHighestLogFile().getParentFile());
        logFiles.shutdown();
    }

    @Test
    public void buildContextWithCustomAbsoluteLogFilesLocations() throws Throwable {
        File customLogDirectory = this.testDirectory.directory("absoluteCustomLogDirectory");
        Config customLogLocationConfig = Config.defaults((Setting)GraphDatabaseSettings.logical_logs_location, (String)customLogDirectory.getAbsolutePath());
        LogFiles logFiles = LogFilesBuilder.builder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withConfig(customLogLocationConfig).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).build();
        logFiles.init();
        logFiles.start();
        Assert.assertEquals((Object)customLogDirectory, (Object)logFiles.getHighestLogFile().getParentFile());
        logFiles.shutdown();
    }

    @Test(expected=NullPointerException.class)
    public void failToBuildFullContextWithoutLogVersionRepo() throws IOException {
        LogFilesBuilder.builder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).buildContext();
    }

    @Test(expected=NullPointerException.class)
    public void failToBuildFullContextWithoutTransactionIdStore() throws IOException {
        LogFilesBuilder.builder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository(2L)).buildContext();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void fileBasedOperationsContextFailOnLastCommittedTransactionIdAccess() throws IOException {
        LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).buildContext().getLastCommittedTransactionId();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void fileBasedOperationsContextFailOnLogVersionRepositoryAccess() throws IOException {
        LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).buildContext().getLogVersionRepository();
    }
}

