/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.List;
import java.util.function.IntPredicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class LabelScanViewNodeStoreScanTest {
    private NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private LabelScanReader labelScanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
    private IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private Visitor<NodeLabelUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private Visitor<NodeUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);

    @Before
    public void setUp() {
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)this.labelScanReader);
    }

    @Test
    public void iterateOverLabeledNodeIds() {
        PrimitiveLongResourceIterator labeledNodes = PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L, 2L, 4L, 8L});
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)15L);
        Mockito.when((Object)this.labelScanReader.nodesWithAnyOfLabels(new int[]{1, 2})).thenReturn((Object)labeledNodes);
        int[] labelIds = new int[]{1, 2};
        LabelScanViewNodeStoreScan<Exception> storeScan = this.getLabelScanViewStoreScan(labelIds);
        PrimitiveLongResourceIterator idIterator = storeScan.getNodeIdIterator();
        List visitedNodeIds = PrimitiveLongCollections.asList((PrimitiveLongIterator)idIterator);
        Assert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasItems((Object[])new Long[]{1L, 2L, 4L, 8L}));
    }

    private LabelScanViewNodeStoreScan<Exception> getLabelScanViewStoreScan(int[] labelIds) {
        return new LabelScanViewNodeStoreScan(this.nodeStore, LockService.NO_LOCK_SERVICE, this.propertyStore, this.labelScanStore, this.labelUpdateVisitor, this.propertyUpdateVisitor, labelIds, this.propertyKeyIdFilter);
    }
}

