/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class KernelDiagnosticsTest {
    @Rule
    public final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldPrintDiskUsage() {
        File storeDir = (File)Mockito.spy((Object)new File("storeDir"));
        Mockito.when((Object)storeDir.getTotalSpace()).thenReturn((Object)100L);
        Mockito.when((Object)storeDir.getFreeSpace()).thenReturn((Object)40L);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        KernelDiagnostics.StoreFiles storeFiles = new KernelDiagnostics.StoreFiles(storeDir);
        storeFiles.dump(logProvider.getLog(this.getClass()).debugLogger());
        logProvider.assertContainsMessageContaining("100 / 40 / 40");
    }

    @Test
    public void shouldCountFileSizeRecursively() throws IOException {
        File storeDir = this.directory.directory("storeDir");
        File indexDir = this.directory(storeDir, "indexDir");
        this.file(indexDir, "indexFile", (int)ByteUnit.kibiBytes((long)1L));
        this.file(storeDir, "neostore", (int)ByteUnit.kibiBytes((long)3L));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        KernelDiagnostics.StoreFiles storeFiles = new KernelDiagnostics.StoreFiles(storeDir);
        storeFiles.dump(logProvider.getLog(this.getClass()).debugLogger());
        logProvider.assertContainsMessageContaining("Total size of store: 4.00 kB");
        logProvider.assertContainsMessageContaining("Total size of mapped files: 3.00 kB");
    }

    private File directory(File parent, String name) throws IOException {
        File dir = new File(parent, name);
        this.fs.mkdirs(dir);
        return dir;
    }

    private File file(File parent, String name, int size) throws IOException {
        File file = new File(parent, name);
        try (StoreChannel channel = this.fs.create(file);){
            ByteBuffer buffer = ByteBuffer.allocate(size);
            buffer.position(size).flip();
            channel.write(buffer);
        }
        return file;
    }
}

