/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.graphdb.PropertyContainer;

public final class Property {
    private final String key;
    private final Object value;

    public static Property property(String key, Object value) {
        return new Property(key, value);
    }

    public static <E extends PropertyContainer> E set(E entity, Property ... properties) {
        for (Property property : properties) {
            entity.setProperty(property.key, property.value);
        }
        return entity;
    }

    private Property(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public Object value() {
        return this.value;
    }

    public String toString() {
        return String.format("%s: %s", this.key, this.value);
    }
}

