/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CalculateDenseNodesStepTest {
    @Test
    public void shouldNotProcessLoopsTwice() throws Exception {
        NodeRelationshipCache cache = (NodeRelationshipCache)Mockito.mock(NodeRelationshipCache.class);
        try (CalculateDenseNodesStep step = new CalculateDenseNodesStep((StageControl)Mockito.mock(StageControl.class), Configuration.DEFAULT, cache, new StatsProvider[0]);){
            step.processors(4);
            step.start(0);
            long id = 0L;
            RelationshipRecord[] batch = CalculateDenseNodesStepTest.batch(CalculateDenseNodesStepTest.relationship(id++, 1L, 5L), CalculateDenseNodesStepTest.relationship(id++, 3L, 10L), CalculateDenseNodesStepTest.relationship(id++, 2L, 2L), CalculateDenseNodesStepTest.relationship(id++, 4L, 1L));
            step.receive(0L, (Object)batch);
            step.endOfUpstream();
            while (!step.isCompleted()) {
            }
            ((NodeRelationshipCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)2))).incrementCount(ArgumentMatchers.eq((long)1L));
            ((NodeRelationshipCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)1))).incrementCount(ArgumentMatchers.eq((long)2L));
            ((NodeRelationshipCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)1))).incrementCount(ArgumentMatchers.eq((long)3L));
            ((NodeRelationshipCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)1))).incrementCount(ArgumentMatchers.eq((long)4L));
            ((NodeRelationshipCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)1))).incrementCount(ArgumentMatchers.eq((long)5L));
            ((NodeRelationshipCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)1))).incrementCount(ArgumentMatchers.eq((long)10L));
        }
    }

    private static RelationshipRecord[] batch(RelationshipRecord ... relationships) {
        return relationships;
    }

    private static RelationshipRecord relationship(long id, long startNodeId, long endNodeId) {
        return new RelationshipRecord(id).initialize(true, Record.NO_NEXT_PROPERTY.longValue(), startNodeId, endNodeId, 0, Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), false, false);
    }
}

