/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.kernel.builtinprocs.NodePropertySchemaInfoResult;
import org.neo4j.kernel.builtinprocs.RelationshipPropertySchemaInfoResult;
import org.neo4j.kernel.builtinprocs.SortedLabels;
import org.neo4j.values.storable.Value;

public class SchemaCalculator {
    private Map<Integer, String> propertyIdToPropertyNameMapping;
    private final Set<Integer> emptyPropertyIdSet = Collections.unmodifiableSet(Collections.emptySet());
    private final Read dataRead;
    private final TokenRead tokenRead;
    private final CursorFactory cursors;

    SchemaCalculator(Transaction ktx) {
        this.dataRead = ktx.dataRead();
        this.tokenRead = ktx.tokenRead();
        this.cursors = ktx.cursors();
        this.propertyIdToPropertyNameMapping = new HashMap<Integer, String>(this.tokenRead.propertyKeyCount());
        this.addNamesToCollection(this.tokenRead.propertyKeyGetAllTokens(), this.propertyIdToPropertyNameMapping);
    }

    private NodeMappings initializeMappingsForNodes() {
        int labelCount = this.tokenRead.labelCount();
        return new NodeMappings(labelCount);
    }

    private RelationshipMappings initializeMappingsForRels() {
        int relationshipTypeCount = this.tokenRead.relationshipTypeCount();
        return new RelationshipMappings(relationshipTypeCount);
    }

    public Stream<NodePropertySchemaInfoResult> calculateTabularResultStreamForNodes() {
        NodeMappings nodeMappings = this.initializeMappingsForNodes();
        this.scanEverythingBelongingToNodes(nodeMappings);
        this.addNamesToCollection(this.tokenRead.labelsGetAllTokens(), nodeMappings.labelIdToLabelName);
        return this.produceResultsForNodes(nodeMappings).stream();
    }

    public Stream<RelationshipPropertySchemaInfoResult> calculateTabularResultStreamForRels() {
        RelationshipMappings relMappings = this.initializeMappingsForRels();
        this.scanEverythingBelongingToRelationships(relMappings);
        this.addNamesToCollection(this.tokenRead.relationshipTypesGetAllTokens(), relMappings.relationshipTypIdToRelationshipName);
        return this.produceResultsForRelationships(relMappings).stream();
    }

    private List<RelationshipPropertySchemaInfoResult> produceResultsForRelationships(RelationshipMappings relMappings) {
        ArrayList<RelationshipPropertySchemaInfoResult> results = new ArrayList<RelationshipPropertySchemaInfoResult>();
        for (Integer typeId : relMappings.relationshipTypeIdToPropertyKeys.keySet()) {
            String name = relMappings.relationshipTypIdToRelationshipName.get(typeId);
            name = ":`" + name + "`";
            Set<Integer> propertyIds = relMappings.relationshipTypeIdToPropertyKeys.get(typeId);
            if (propertyIds.size() == 0) {
                results.add(new RelationshipPropertySchemaInfoResult(name, null, null, false));
                continue;
            }
            String finalName = name;
            propertyIds.forEach(propId -> {
                String propName = this.propertyIdToPropertyNameMapping.get(propId);
                ValueTypeListHelper valueTypeListHelper = relMappings.relationshipTypeIdANDPropertyTypeIdToValueType.get(Pair.of((Object)typeId, (Object)propId));
                if (relMappings.nullableRelationshipTypes.contains(typeId)) {
                    results.add(new RelationshipPropertySchemaInfoResult(finalName, propName, valueTypeListHelper.getCypherTypesList(), false));
                } else {
                    results.add(new RelationshipPropertySchemaInfoResult(finalName, propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isMandatory()));
                }
            });
        }
        return results;
    }

    private List<NodePropertySchemaInfoResult> produceResultsForNodes(NodeMappings nodeMappings) {
        ArrayList<NodePropertySchemaInfoResult> results = new ArrayList<NodePropertySchemaInfoResult>();
        for (SortedLabels labelSet : nodeMappings.labelSetToPropertyKeys.keySet()) {
            ArrayList<String> labelNames = new ArrayList<String>();
            for (int i = 0; i < labelSet.numberOfLabels(); ++i) {
                String name = nodeMappings.labelIdToLabelName.get(labelSet.label(i));
                labelNames.add(name);
            }
            Collections.sort(labelNames);
            StringBuilder labelsConcatenator = new StringBuilder();
            for (String item : labelNames) {
                labelsConcatenator.append(":`").append(item).append("`");
            }
            String labels = labelsConcatenator.toString();
            Set<Integer> propertyIds = nodeMappings.labelSetToPropertyKeys.get(labelSet);
            if (propertyIds.size() == 0) {
                results.add(new NodePropertySchemaInfoResult(labels, labelNames, null, null, false));
                continue;
            }
            propertyIds.forEach(propId -> {
                String propName = this.propertyIdToPropertyNameMapping.get(propId);
                ValueTypeListHelper valueTypeListHelper = nodeMappings.labelSetANDNodePropertyKeyIdToValueType.get(Pair.of((Object)labelSet, (Object)propId));
                if (nodeMappings.nullableLabelSets.contains(labelSet)) {
                    results.add(new NodePropertySchemaInfoResult(labels, labelNames, propName, valueTypeListHelper.getCypherTypesList(), false));
                } else {
                    results.add(new NodePropertySchemaInfoResult(labels, labelNames, propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isMandatory()));
                }
            });
        }
        return results;
    }

    private void scanEverythingBelongingToRelationships(RelationshipMappings relMappings) {
        try (RelationshipScanCursor relationshipScanCursor = this.cursors.allocateRelationshipScanCursor();
             PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor();){
            this.dataRead.allRelationshipsScan(relationshipScanCursor);
            while (relationshipScanCursor.next()) {
                int typeId = relationshipScanCursor.type();
                relationshipScanCursor.properties(propertyCursor);
                HashSet<Integer> propertyIds = new HashSet<Integer>();
                while (propertyCursor.next()) {
                    int propertyKey = propertyCursor.propertyKey();
                    Value currentValue = propertyCursor.propertyValue();
                    Pair key = Pair.of((Object)typeId, (Object)propertyKey);
                    this.updateValueTypeInMapping(currentValue, key, relMappings.relationshipTypeIdANDPropertyTypeIdToValueType);
                    propertyIds.add(propertyKey);
                }
                propertyCursor.close();
                Set<Integer> oldPropertyKeySet = relMappings.relationshipTypeIdToPropertyKeys.getOrDefault(typeId, this.emptyPropertyIdSet);
                if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                    if (propertyIds.size() == 0) {
                        relMappings.nullableRelationshipTypes.add(typeId);
                    }
                    propertyIds.addAll(oldPropertyKeySet);
                } else {
                    HashSet<Integer> currentPropertyIdsHelperSet = new HashSet<Integer>(propertyIds);
                    currentPropertyIdsHelperSet.addAll(propertyIds);
                    propertyIds.removeAll(oldPropertyKeySet);
                    oldPropertyKeySet.removeAll(currentPropertyIdsHelperSet);
                    propertyIds.addAll(oldPropertyKeySet);
                    propertyIds.forEach(id -> {
                        Pair key = Pair.of((Object)typeId, (Object)id);
                        relMappings.relationshipTypeIdANDPropertyTypeIdToValueType.get(key).setNullable();
                    });
                    propertyIds.addAll(currentPropertyIdsHelperSet);
                }
                relMappings.relationshipTypeIdToPropertyKeys.put(typeId, propertyIds);
            }
            relationshipScanCursor.close();
        }
    }

    private void scanEverythingBelongingToNodes(NodeMappings nodeMappings) {
        try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor();
             PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor();){
            this.dataRead.allNodesScan(nodeCursor);
            while (nodeCursor.next()) {
                SortedLabels labels = SortedLabels.from(nodeCursor.labels());
                nodeCursor.properties(propertyCursor);
                HashSet<Integer> propertyIds = new HashSet<Integer>();
                while (propertyCursor.next()) {
                    Value currentValue = propertyCursor.propertyValue();
                    int propertyKeyId = propertyCursor.propertyKey();
                    Pair key = Pair.of((Object)labels, (Object)propertyKeyId);
                    this.updateValueTypeInMapping(currentValue, key, nodeMappings.labelSetANDNodePropertyKeyIdToValueType);
                    propertyIds.add(propertyKeyId);
                }
                propertyCursor.close();
                Set<Integer> oldPropertyKeySet = nodeMappings.labelSetToPropertyKeys.getOrDefault(labels, this.emptyPropertyIdSet);
                if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                    if (propertyIds.size() == 0) {
                        nodeMappings.nullableLabelSets.add(labels);
                    }
                    propertyIds.addAll(oldPropertyKeySet);
                } else {
                    HashSet<Integer> currentPropertyIdsHelperSet = new HashSet<Integer>(propertyIds);
                    currentPropertyIdsHelperSet.addAll(propertyIds);
                    propertyIds.removeAll(oldPropertyKeySet);
                    oldPropertyKeySet.removeAll(currentPropertyIdsHelperSet);
                    propertyIds.addAll(oldPropertyKeySet);
                    propertyIds.forEach(id -> {
                        Pair key = Pair.of((Object)labels, (Object)id);
                        nodeMappings.labelSetANDNodePropertyKeyIdToValueType.get(key).setNullable();
                    });
                    propertyIds.addAll(currentPropertyIdsHelperSet);
                }
                nodeMappings.labelSetToPropertyKeys.put(labels, propertyIds);
            }
            nodeCursor.close();
        }
    }

    private <X, Y> void updateValueTypeInMapping(Value currentValue, Pair<X, Y> key, Map<Pair<X, Y>, ValueTypeListHelper> mappingToUpdate) {
        ValueTypeListHelper helper = mappingToUpdate.get(key);
        if (helper == null) {
            helper = new ValueTypeListHelper(currentValue);
            mappingToUpdate.put(key, helper);
        } else {
            helper.updateValueTypesWith(currentValue);
        }
    }

    private void addNamesToCollection(Iterator<NamedToken> labelIterator, Map<Integer, String> collection) {
        while (labelIterator.hasNext()) {
            NamedToken label = labelIterator.next();
            collection.put(label.id(), label.name());
        }
    }

    private class RelationshipMappings {
        final Map<Integer, String> relationshipTypIdToRelationshipName;
        final Map<Integer, Set<Integer>> relationshipTypeIdToPropertyKeys;
        final Map<Pair<Integer, Integer>, ValueTypeListHelper> relationshipTypeIdANDPropertyTypeIdToValueType;
        final Set<Integer> nullableRelationshipTypes;

        RelationshipMappings(int relationshipTypeCount) {
            this.relationshipTypIdToRelationshipName = new HashMap<Integer, String>(relationshipTypeCount);
            this.relationshipTypeIdToPropertyKeys = new HashMap<Integer, Set<Integer>>(relationshipTypeCount);
            this.relationshipTypeIdANDPropertyTypeIdToValueType = new HashMap<Pair<Integer, Integer>, ValueTypeListHelper>();
            this.nullableRelationshipTypes = new HashSet<Integer>();
        }
    }

    private class NodeMappings {
        final Map<SortedLabels, Set<Integer>> labelSetToPropertyKeys;
        final Map<Pair<SortedLabels, Integer>, ValueTypeListHelper> labelSetANDNodePropertyKeyIdToValueType;
        final Set<SortedLabels> nullableLabelSets;
        final Map<Integer, String> labelIdToLabelName;

        NodeMappings(int labelCount) {
            this.labelSetToPropertyKeys = new HashMap<SortedLabels, Set<Integer>>(labelCount);
            this.labelIdToLabelName = new HashMap<Integer, String>(labelCount);
            this.labelSetANDNodePropertyKeyIdToValueType = new HashMap<Pair<SortedLabels, Integer>, ValueTypeListHelper>();
            this.nullableLabelSets = new HashSet<SortedLabels>();
        }
    }

    private class ValueTypeListHelper {
        private Set<String> seenValueTypes = new HashSet<String>();
        private boolean isMandatory = true;

        ValueTypeListHelper(Value v) {
            this.updateValueTypesWith(v);
        }

        private void setNullable() {
            this.isMandatory = false;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }

        List<String> getCypherTypesList() {
            return new ArrayList<String>(this.seenValueTypes);
        }

        void updateValueTypesWith(Value newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException();
            }
            this.seenValueTypes.add(newValue.getTypeName());
        }
    }
}

