/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

@RunWith(value=Parameterized.class)
public class IndexingCompositeQueryAcceptanceTest {
    @ClassRule
    public static ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    @Parameterized.Parameter(value=0)
    public String[] keys;
    @Parameterized.Parameter(value=1)
    public Object[] values;
    @Parameterized.Parameter(value=2)
    public Object[][] nonMatching;
    @Parameterized.Parameter(value=3)
    public IndexSeek indexSeek;
    @Parameterized.Parameter(value=4)
    public boolean withIndex;
    private static Label LABEL = Label.label((String)"LABEL1");
    private GraphDatabaseService db;
    public static IndexSeek biIndexSeek = (keys, values, db) -> {
        assert (keys.length == 2);
        assert (values.length == 2);
        return db.findNodes(LABEL, keys[0], values[0], keys[1], values[1]);
    };
    public static IndexSeek triIndexSeek = (keys, values, db) -> {
        assert (keys.length == 3);
        assert (values.length == 3);
        return db.findNodes(LABEL, keys[0], values[0], keys[1], values[1], keys[2], values[2]);
    };
    public static IndexSeek mapIndexSeek = (keys, values, db) -> db.findNodes(LABEL, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, values));

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList(IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3}), biIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3}), biIndexSeek, false), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4}), triIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4}), triIndexSeek, false), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4, 5, 6}), mapIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4, 5, 6}), mapIndexSeek, false));
    }

    @Before
    public void setup() {
        this.db = dbRule.getGraphDatabaseAPI();
        if (this.withIndex) {
            try (Transaction tx = this.db.beginTx();){
                this.db.schema().indexFor(LABEL).on(this.keys[0]).create();
                IndexCreator indexCreator = this.db.schema().indexFor(LABEL);
                for (String key : this.keys) {
                    indexCreator = indexCreator.on(key);
                }
                indexCreator.create();
                tx.success();
            }
            tx = this.db.beginTx();
            var2_2 = null;
            try {
                this.db.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
                tx.success();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var2_2 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    @After
    public void tearDown() {
        dbRule.shutdown();
    }

    @Test
    public void shouldSupportIndexSeek() {
        this.createNodes(this.db, LABEL, this.nonMatching);
        PrimitiveLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            this.collectNodes(found, this.indexSeek.findNodes(this.keys, this.values, this.db));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldSupportIndexSeekBackwardsOrder() {
        this.createNodes(this.db, LABEL, this.nonMatching);
        PrimitiveLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        PrimitiveLongSet found = Primitive.longSet();
        String[] reversedKeys = new String[this.keys.length];
        Object[] reversedValues = new Object[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            reversedValues[this.keys.length - 1 - i] = this.values[i];
            reversedKeys[this.keys.length - 1 - i] = this.keys[i];
        }
        try (Transaction tx = this.db.beginTx();){
            this.collectNodes(found, this.indexSeek.findNodes(reversedKeys, reversedValues, this.db));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldIncludeNodesCreatedInSameTxInIndexSeek() {
        this.createNodes(this.db, LABEL, this.nonMatching[0], this.nonMatching[1]);
        PrimitiveLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            expected.add(this.createNode(this.db, IndexingCompositeQueryAcceptanceTest.propertyMap(this.keys, this.values), LABEL).getId());
            this.createNode(this.db, IndexingCompositeQueryAcceptanceTest.propertyMap(this.keys, this.nonMatching[2]), LABEL);
            this.collectNodes(found, this.indexSeek.findNodes(this.keys, this.values, this.db));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldNotIncludeNodesDeletedInSameTxInIndexSeek() {
        this.createNodes(this.db, LABEL, new Object[][]{this.nonMatching[0]});
        PrimitiveLongSet toDelete = this.createNodes(this.db, LABEL, this.values, this.nonMatching[1], this.nonMatching[2]);
        PrimitiveLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            for (long id : toDelete) {
                this.db.getNodeById(id).delete();
                expected.remove(id);
            }
            this.collectNodes(found, this.indexSeek.findNodes(this.keys, this.values, this.db));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldConsiderNodesChangedInSameTxInIndexSeek() {
        this.createNodes(this.db, LABEL, new Object[][]{this.nonMatching[0]});
        PrimitiveLongSet toChangeToMatch = this.createNodes(this.db, LABEL, new Object[][]{this.nonMatching[1]});
        PrimitiveLongSet toChangeToNotMatch = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        PrimitiveLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            for (long id : toChangeToMatch) {
                this.setProperties(id, this.values);
                expected.add(id);
            }
            for (long id : toChangeToNotMatch) {
                this.setProperties(id, this.nonMatching[2]);
                expected.remove(id);
            }
            this.collectNodes(found, this.indexSeek.findNodes(this.keys, this.values, this.db));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    public PrimitiveLongSet createNodes(GraphDatabaseService db, Label label, Object[] ... propertyValueTuples) {
        PrimitiveLongSet expected = Primitive.longSet();
        try (Transaction tx = db.beginTx();){
            for (Object[] valueTuple : propertyValueTuples) {
                expected.add(this.createNode(db, IndexingCompositeQueryAcceptanceTest.propertyMap(this.keys, valueTuple), label).getId());
            }
            tx.success();
        }
        return expected;
    }

    public static Map<String, Object> propertyMap(String[] keys, Object[] valueTuple) {
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            propertyValues.put(keys[i], valueTuple[i]);
        }
        return propertyValues;
    }

    public void collectNodes(PrimitiveLongSet bucket, ResourceIterator<Node> toCollect) {
        while (toCollect.hasNext()) {
            bucket.add(((Node)toCollect.next()).getId());
        }
    }

    public Node createNode(GraphDatabaseService beansAPI, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = beansAPI.beginTx();){
            Node node = beansAPI.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    public static Object[] testCase(Integer[] values, IndexSeek indexSeek, boolean withIndex) {
        Object[][] nonMatching = new Object[][]{IndexingCompositeQueryAcceptanceTest.plus(values, 1), IndexingCompositeQueryAcceptanceTest.plus(values, 2), IndexingCompositeQueryAcceptanceTest.plus(values, 3)};
        String[] keys = (String[])Arrays.stream(values).map(v -> "key" + v).toArray(String[]::new);
        return new Object[]{keys, values, nonMatching, indexSeek, withIndex};
    }

    public static <T> Object[] plus(Integer[] values, int offset) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] + offset;
        }
        return result;
    }

    private void setProperties(long id, Object[] values) {
        Node node = this.db.getNodeById(id);
        for (int i = 0; i < this.keys.length; ++i) {
            node.setProperty(this.keys[i], values[i]);
        }
    }

    public static interface IndexSeek {
        public ResourceIterator<Node> findNodes(String[] var1, Object[] var2, GraphDatabaseService var3);
    }
}

