/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.progress.Indicator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.test.rule.SuppressOutput;

public class ProgressMonitorTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final SingleIndicator factory = new SingleIndicator();
    private static final String EXPECTED_TEXTUAL_OUTPUT;

    @Test
    public void shouldReportProgressInTheSpecifiedIntervals() {
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressListener progressListener = this.factory.mock(indicator, 10).singlePart(this.testName.getMethodName(), 16L);
        progressListener.started();
        for (int i = 0; i < 16; ++i) {
            progressListener.add(1L);
        }
        progressListener.done();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(16L);
        for (int i = 0; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAggregateProgressFromMultipleProcesses() {
        int i;
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        ProgressListener first = builder.progressForPart("first", 5L);
        ProgressListener other = builder.progressForPart("other", 5L);
        builder.build();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(10L);
        order.verifyNoMoreInteractions();
        first.started();
        for (i = 0; i < 5; ++i) {
            first.add(1L);
        }
        first.done();
        ((Indicator)order.verify((Object)indicator)).startPart("first", 5L);
        for (i = 0; i < 5; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("first");
        order.verifyNoMoreInteractions();
        other.started();
        for (i = 0; i < 5; ++i) {
            other.add(1L);
        }
        other.done();
        ((Indicator)order.verify((Object)indicator)).startPart("other", 5L);
        for (i = 5; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("other");
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldNotAllowAddingPartsAfterCompletingMultiPartBuilder() {
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(ProgressMonitorTest.indicatorMock(), 10).multipleParts(this.testName.getMethodName());
        builder.progressForPart("first", 10L);
        builder.build();
        this.expected.expect(IllegalStateException.class);
        this.expected.expectMessage("Builder has been completed.");
        builder.progressForPart("other", 10L);
    }

    @Test
    public void shouldNotAllowAddingMultiplePartsWithSameIdentifier() {
        ProgressMonitorFactory.MultiPartBuilder builder = ((ProgressMonitorFactory)Mockito.mock(ProgressMonitorFactory.class)).multipleParts(this.testName.getMethodName());
        builder.progressForPart("first", 10L);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Part 'first' has already been defined.");
        builder.progressForPart("first", 10L);
    }

    @Test
    public void shouldStartProcessAutomaticallyIfNotDoneBefore() {
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressListener progressListener = this.factory.mock(indicator, 10).singlePart(this.testName.getMethodName(), 16L);
        for (int i = 0; i < 16; ++i) {
            progressListener.add(1L);
        }
        progressListener.done();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator, Mockito.times((int)1))).startProcess(16L);
        for (int i = 0; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldStartMultiPartProcessAutomaticallyIfNotDoneBefore() {
        int i;
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        ProgressListener first = builder.progressForPart("first", 5L);
        ProgressListener other = builder.progressForPart("other", 5L);
        builder.build();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(10L);
        order.verifyNoMoreInteractions();
        for (i = 0; i < 5; ++i) {
            first.add(1L);
        }
        first.done();
        ((Indicator)order.verify((Object)indicator)).startPart("first", 5L);
        for (i = 0; i < 5; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("first");
        order.verifyNoMoreInteractions();
        for (i = 0; i < 5; ++i) {
            other.add(1L);
        }
        other.done();
        ((Indicator)order.verify((Object)indicator)).startPart("other", 5L);
        for (i = 5; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("other");
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldCompleteMultiPartProgressWithNoPartsImmediately() {
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        builder.build();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(0L);
        ((Indicator)order.verify((Object)indicator)).progress(0, 10);
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    private static Indicator indicatorMock() {
        Indicator indicator = (Indicator)Mockito.mock(Indicator.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((Indicator)Mockito.doNothing().when((Object)indicator)).progress(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        return indicator;
    }

    @Test
    public void shouldPrintADotEveryHalfPercentAndFullPercentageEveryTenPercentWithTextualIndicator() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ProgressListener progressListener = ProgressMonitorFactory.textual((OutputStream)stream).singlePart(this.testName.getMethodName(), 1000L);
        for (int i = 0; i < 1000; ++i) {
            progressListener.add(1L);
        }
        Assert.assertEquals((Object)(this.testName.getMethodName() + System.lineSeparator() + EXPECTED_TEXTUAL_OUTPUT), (Object)stream.toString(Charset.defaultCharset().name()));
    }

    @Test
    public void shouldPrintADotEveryHalfPercentAndFullPercentageEveryTenPercentEvenWhenStepResolutionIsLower() {
        StringWriter writer = new StringWriter();
        ProgressListener progressListener = ProgressMonitorFactory.textual((Writer)writer).singlePart(this.testName.getMethodName(), 50L);
        for (int i = 0; i < 50; ++i) {
            progressListener.add(1L);
        }
        Assert.assertEquals((Object)(this.testName.getMethodName() + System.lineSeparator() + EXPECTED_TEXTUAL_OUTPUT), (Object)writer.toString());
    }

    @Test
    public void shouldAllowStartingAPartBeforeCompletionOfMultiPartBuilder() {
        Indicator indicator = (Indicator)Mockito.mock(Indicator.class);
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        ProgressListener part1 = builder.progressForPart("part1", 1L);
        ProgressListener part2 = builder.progressForPart("part2", 1L);
        part1.add(1L);
        builder.build();
        part2.add(1L);
        part1.done();
        part2.done();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startPart("part1", 1L);
        ((Indicator)order.verify((Object)indicator)).startProcess(2L);
        ((Indicator)order.verify((Object)indicator)).startPart("part2", 1L);
        ((Indicator)order.verify((Object)indicator)).completePart("part1");
        ((Indicator)order.verify((Object)indicator)).completePart("part2");
        ((Indicator)order.verify((Object)indicator)).completeProcess();
    }

    static {
        StringWriter expectedTextualOutput = new StringWriter();
        int i = 0;
        while (i < 10) {
            for (int j = 0; j < 20; ++j) {
                expectedTextualOutput.write(46);
            }
            expectedTextualOutput.write(String.format(" %3d%%%n", ++i * 10));
        }
        EXPECTED_TEXTUAL_OUTPUT = expectedTextualOutput.toString();
    }

    private static class SingleIndicator
    implements TestRule {
        private final Map<ProgressMonitorFactory, Boolean> factoryMocks = new HashMap<ProgressMonitorFactory, Boolean>();

        private SingleIndicator() {
        }

        ProgressMonitorFactory mock(Indicator indicatorMock, int indicatorSteps) {
            Mockito.when((Object)indicatorMock.reportResolution()).thenReturn((Object)indicatorSteps);
            ProgressMonitorFactory factory = (ProgressMonitorFactory)Mockito.mock(ProgressMonitorFactory.class);
            Mockito.when((Object)factory.newIndicator((String)ArgumentMatchers.any(String.class))).thenReturn((Object)indicatorMock);
            this.factoryMocks.put(factory, false);
            return factory;
        }

        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    base.evaluate();
                    for (Map.Entry factoryMock : factoryMocks.entrySet()) {
                        ((ProgressMonitorFactory)Mockito.verify(factoryMock.getKey(), (VerificationMode)Mockito.times((int)1))).newIndicator((String)ArgumentMatchers.any(String.class));
                    }
                }
            };
        }
    }
}

