/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;

public class ResampleIndexProcedureTest {
    private IndexingService indexingService;
    private IndexProcedures procedure;
    private TokenRead tokenRead;
    private SchemaRead schemaRead;

    @Before
    public void setup() {
        KernelTransaction transaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        this.tokenRead = (TokenRead)Mockito.mock(TokenRead.class);
        this.schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
        this.procedure = new IndexProcedures(transaction, null);
        Mockito.when((Object)transaction.tokenRead()).thenReturn((Object)this.tokenRead);
        Mockito.when((Object)transaction.schemaRead()).thenReturn((Object)this.schemaRead);
        this.indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        this.procedure = new IndexProcedures(transaction, this.indexingService);
    }

    @Test
    public void shouldThrowAnExceptionIfTheLabelDoesntExist() {
        Mockito.when((Object)this.tokenRead.nodeLabel("NonExistentLabel")).thenReturn((Object)-1);
        try {
            this.procedure.resampleIndex(":NonExistentLabel(prop)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.LabelAccessFailed));
        }
    }

    @Test
    public void shouldThrowAnExceptionIfThePropertyKeyDoesntExist() {
        Mockito.when((Object)this.tokenRead.propertyKey("nonExistentProperty")).thenReturn((Object)-1);
        try {
            this.procedure.resampleIndex(":Label(nonExistentProperty)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.PropertyKeyAccessFailed));
        }
    }

    @Test
    public void shouldLookUpTheIndexByLabelIdAndPropertyKeyId() throws ProcedureException, SchemaRuleNotFoundException {
        SchemaIndexDescriptor index = SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)123);
        Mockito.when((Object)this.tokenRead.propertyKey(ArgumentMatchers.anyString())).thenReturn((Object)456);
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), (int[])ArgumentMatchers.any())).thenReturn((Object)DefaultCapableIndexReference.fromDescriptor((SchemaIndexDescriptor)index));
        this.procedure.resampleIndex(":Person(name)");
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index(123, new int[]{456});
    }

    @Test
    public void shouldLookUpTheCompositeIndexByLabelIdAndPropertyKeyId() throws ProcedureException, SchemaRuleNotFoundException {
        SchemaIndexDescriptor index = SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1});
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)123);
        Mockito.when((Object)this.tokenRead.propertyKey("name")).thenReturn((Object)0);
        Mockito.when((Object)this.tokenRead.propertyKey("lastName")).thenReturn((Object)1);
        Mockito.when((Object)this.schemaRead.index(123, new int[]{0, 1})).thenReturn((Object)DefaultCapableIndexReference.fromDescriptor((SchemaIndexDescriptor)index));
        this.procedure.resampleIndex(":Person(name, lastName)");
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index(123, new int[]{0, 1});
    }

    @Test
    public void shouldThrowAnExceptionIfTheIndexDoesNotExist() throws SchemaRuleNotFoundException {
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.tokenRead.propertyKey(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), (int[])ArgumentMatchers.any())).thenReturn((Object)CapableIndexReference.NO_INDEX);
        try {
            this.procedure.resampleIndex(":Person(name)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.IndexNotFound));
        }
    }

    @Test
    public void shouldTriggerResampling() throws SchemaRuleNotFoundException, ProcedureException, IndexNotFoundKernelException {
        SchemaIndexDescriptor index = SchemaIndexDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), (int[])ArgumentMatchers.any())).thenReturn((Object)DefaultCapableIndexReference.fromDescriptor((SchemaIndexDescriptor)index));
        this.procedure.resampleIndex(":Person(name)");
        ((IndexingService)Mockito.verify((Object)this.indexingService)).triggerIndexSampling(index.schema(), IndexSamplingMode.TRIGGER_REBUILD_ALL);
    }
}

