/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.test.MockedNeoStores;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Enclosed.class)
public class StorePropertyCursorTest {
    private static final List<Object[]> PARAMETERS = Arrays.asList({false, PropertyType.BOOL}, {(byte)3, PropertyType.BYTE}, {(short)34, PropertyType.SHORT}, {3456, PropertyType.INT}, {3456L, PropertyType.LONG}, {0xFFFFFFFEL, PropertyType.LONG}, {Float.valueOf(1.6f), PropertyType.FLOAT}, {1.9, PropertyType.DOUBLE}, {Character.valueOf('a'), PropertyType.CHAR}, {"short", PropertyType.SHORT_STRING}, {"notsoshort", PropertyType.SHORT_STRING}, {"alongershortstring", PropertyType.SHORT_STRING}, {"areallylongshortstringbutstillnotsobig", PropertyType.SHORT_STRING}, {Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.234, 4.321}), PropertyType.GEOMETRY}, {Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.234, 4.321, -6.543}), PropertyType.GEOMETRY}, {new double[]{0.0}, PropertyType.SHORT_ARRAY}, {new double[]{1.2}, PropertyType.SHORT_ARRAY}, {new double[]{1.2, 1.4}, PropertyType.SHORT_ARRAY}, {new double[]{1.2, 1.4, 1.6}, PropertyType.SHORT_ARRAY}, {new double[]{1.2, 1.4, 1.6, 1.8}, PropertyType.ARRAY}, {new double[]{1.2, 1.4, 1.6, 1.8, 2.2, 2.4, 2.6, 2.8, 3.2, 3.4, 3.6, 3.8}, PropertyType.ARRAY}, {new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.234, 4.321}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{4.321, -6.543})}, PropertyType.ARRAY}, {new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{3.987, 1.234, 4.321}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.234, 4.321, -6.543})}, PropertyType.ARRAY}, {"thisisaveryveryveryverylongstringwhichisnotgonnafiteverintothepropertyblock", PropertyType.STRING}, {new BigProperty("thisisaveryveryveryverylongstringwhichisnotgonnafiteverintothepropertyblock\nthisisaveryveryveryverylongstringwhichisnotgonnafiteverintothepropertyblock", "two very long lines..."), PropertyType.STRING}, {new BigProperty("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare augue a felis interdum, id sodales magna tempor. Donec aliquam, nunc eu semper semper, orci metus tincidunt urna, non sagittis eros tellus vel tellus. Maecenas vel nisi magna. Morbi tincidunt pretium nibh, eu tristique magna cursus vitae. Sed vel ultricies sem. Nunc blandit nulla leo, a tempor libero placerat ut. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Phasellus in velit vel dui euismod semper id varius neque. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nam ultrices accumsan ultrices.\n\nAenean laoreet tellus non velit vulputate finibus. Mauris facilisis mi ac eros hendrerit, mollis cursus lectus tincidunt. Sed et enim porta, mollis massa a, ornare lacus. Donec condimentum purus risus, ut vestibulum orci accumsan nec. Mauris condimentum aliquet felis, nec porttitor nunc faucibus vel. Donec eget rutrum urna. Donec aliquet, sapien quis ornare vulputate, tortor massa facilisis leo, nec pharetra dolor sapien non nunc. Mauris erat nulla, aliquam a sem sed, cursus ornare leo. Nulla et volutpat ligula. Curabitur iaculis massa vitae purus pretium, sed vehicula leo facilisis. Aenean egestas augue sit amet ex finibus, eu varius nisi tristique. Aenean molestie nisi vitae erat euismod pharetra.\n\nNunc eu dolor euismod, commodo magna at, molestie velit. Cras vitae posuere sem, quis egestas mi. Morbi vestibulum, lorem sit amet semper porta, purus lorem rhoncus augue, non posuere justo magna sed diam. Donec a neque ac enim placerat semper eu ac purus. Duis sit amet sodales ligula. Vestibulum et dui tempus, molestie diam ut, commodo felis. Sed at congue ligula, fermentum sagittis turpis.\n\nFusce in pharetra nisl. Pellentesque urna urna, rutrum ac tellus sed, rutrum mattis magna. Donec facilisis, tellus consequat placerat mollis, mauris dui molestie ligula, ut ullamcorper lectus tortor in nisl. Aenean congue semper turpis. Mauris iaculis mi vel neque rutrum, vel viverra tellus hendrerit. Nam sed tincidunt lorem. Vestibulum eleifend augue magna, nec gravida leo finibus id. Phasellus id arcu eget ipsum cursus placerat. Donec sit amet lorem porttitor nibh suscipit lobortis. Donec ultrices, purus nec convallis blandit, mi nisl tincidunt justo, dignissim maximus nisi nulla quis dui. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer ac rhoncus nunc. Donec varius tempus imperdiet. Aenean at semper elit. Donec mattis imperdiet sem. Ut dolor augue, bibendum et metus nec, vestibulum blandit dolor.\n\nProin dui nisi, malesuada lacinia sodales sed, porta et arcu. Quisque in massa a diam ultrices porttitor. Mauris vulputate ipsum dignissim eros sodales facilisis in vel nunc. Fusce blandit efficitur convallis. Sed ut ex ac mauris dignissim tempor. Morbi a dui nibh. Suspendisse eu lobortis lorem. Curabitur dictum convallis sapien, ac egestas odio hendrerit at.\n\nDonec nisi arcu, porta quis tristique ac, elementum vitae purus. Suspendisse tempor lorem eu metus gravida consectetur. Donec sapien felis, aliquam eget diam at, ultricies tristique velit. In libero velit, pulvinar accumsan fermentum a, mollis id risus. Praesent facilisis convallis dolor, et cursus tellus varius tristique. Vivamus ac eros pulvinar, blandit ipsum ac, interdum turpis. Donec nec ultrices elit. Proin auctor, nisl vitae viverra ornare, nisl ipsum congue ligula, et tempor diam orci ac ex. In faucibus massa quis purus malesuada convallis. Suspendisse metus ex, malesuada vel auctor et, finibus quis nulla. Cras tincidunt, mauris ac varius tincidunt, enim nunc finibus libero, et euismod quam dolor non magna. Nulla rhoncus dolor a nulla hendrerit iaculis. Nunc tristique, ante id tincidunt feugiat, ligula ipsum faucibus dui, sed suscipit eros nulla non augue. Donec hendrerit arcu sit amet ex laoreet, sit amet gravida risus aliquam. Nullam efficitur placerat sem quis venenatis.\n\nNullam scelerisque purus urna, vel laoreet velit consequat congue. Morbi tincidunt aliquet dignissim. Fusce neque mauris, euismod eu orci a, hendrerit pretium metus. In imperdiet nibh non augue pharetra, nec aliquet orci molestie. Morbi quis blandit leo. Mauris facilisis urna vitae ante molestie, ut efficitur dui elementum. Suspendisse a lectus sit amet turpis feugiat pellentesque ac vel nulla. Proin lobortis ante tincidunt porttitor aliquam. Praesent consequat blandit magna, sit amet finibus dui dapibus eget. Integer quis sem ut justo vulputate volutpat. Vestibulum nec varius lacus. Maecenas eget metus sed lectus suscipit laoreet. Sed mattis magna eu nunc ultrices vestibulum nec vel lacus. Curabitur dapibus nec arcu non tincidunt. Duis eget nulla dictum, lobortis leo ultrices, eleifend neque.\n\nAliquam egestas tortor mi, sed blandit odio sollicitudin et. Mauris fermentum eros orci, id euismod ante interdum vel. Mauris egestas molestie augue, eu rutrum massa interdum in. Mauris sit amet facilisis risus, a convallis nunc. Vivamus hendrerit lobortis ex et ullamcorper. Sed suscipit egestas aliquet. Cras quis bibendum lacus. Nulla maximus consectetur purus quis varius. Nullam ultricies vehicula lectus, eget elementum elit commodo sit amet. Quisque molestie finibus est vel bibendum. Vestibulum a imperdiet turpis, ut volutpat orci. Morbi erat augue, varius sed ullamcorper auctor, varius tincidunt ante. Vivamus mattis justo nulla, auctor euismod nulla mollis id. ", "Lorem ipsum... ad infinitum..."), PropertyType.STRING});

    private StorePropertyCursorTest() {
    }

    private static Object actualValue(Object parameter) {
        return parameter instanceof BigProperty ? ((BigProperty)parameter).value() : parameter;
    }

    private static void assertEqualValues(Object expectedValue, PropertyItem item) {
        Value expected = Values.of((Object)expectedValue);
        Assert.assertTrue((boolean)item.value().equals(expected));
        Assert.assertTrue((boolean)item.value().equals(expected));
    }

    public static long firstIdOf(List<PropertyRecord> propertyChain) {
        return propertyChain.get(0).getId();
    }

    private static StorePropertyCursor newStorePropertyCursor(PropertyStore propertyStore) {
        return StorePropertyCursorTest.newStorePropertyCursor(propertyStore, ignored -> {});
    }

    private static StorePropertyCursor newStorePropertyCursor(PropertyStore propertyStore, Consumer<StorePropertyCursor> cache) {
        RecordCursor propertyRecordCursor = propertyStore.newRecordCursor((AbstractBaseRecord)propertyStore.newRecord());
        propertyRecordCursor.acquire(0L, RecordLoad.NORMAL);
        DynamicStringStore stringStore = propertyStore.getStringStore();
        RecordCursor dynamicStringCursor = stringStore.newRecordCursor((AbstractBaseRecord)stringStore.nextRecord());
        dynamicStringCursor.acquire(0L, RecordLoad.NORMAL);
        DynamicArrayStore arrayStore = propertyStore.getArrayStore();
        RecordCursor dynamicArrayCursor = arrayStore.newRecordCursor((AbstractBaseRecord)arrayStore.nextRecord());
        dynamicArrayCursor.acquire(0L, RecordLoad.NORMAL);
        RecordCursors cursors = (RecordCursors)Mockito.mock(RecordCursors.class);
        Mockito.when((Object)cursors.property()).thenReturn((Object)propertyRecordCursor);
        Mockito.when((Object)cursors.propertyString()).thenReturn((Object)dynamicStringCursor);
        Mockito.when((Object)cursors.propertyArray()).thenReturn((Object)dynamicArrayCursor);
        return new StorePropertyCursor(cursors, cache);
    }

    private static List<PropertyRecord> createPropertyChain(PropertyStore store, int keyId, Object ... values) {
        ArrayList<PropertyRecord> records = new ArrayList<PropertyRecord>();
        for (Object value : values) {
            PropertyRecord record = StorePropertyCursorTest.createSinglePropertyValue(store, keyId, value);
            if (!records.isEmpty()) {
                PropertyRecord previousRecord = (PropertyRecord)records.get(records.size() - 1);
                record.setPrevProp(previousRecord.getId());
                store.updateRecord(record);
                previousRecord.setNextProp(record.getId());
                store.updateRecord(previousRecord);
            }
            records.add(record);
        }
        return records;
    }

    private static void markPropertyRecordsNoInUse(PropertyStore store, int ... recordIds) {
        for (int recordId : recordIds) {
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)store, (long)recordId);
            record.setInUse(false);
            store.updateRecord(record);
        }
    }

    public static int[] idsOf(List<PropertyRecord> propertyChain, int startIndex, int step, int count) {
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = Math.toIntExact(propertyChain.get(startIndex + i * step).getId());
        }
        return result;
    }

    private static PropertyRecord createSinglePropertyValue(PropertyStore store, int keyId, Object value) {
        DynamicStringStore stringAllocator = store.getStringStore();
        DynamicArrayStore arrayAllocator = store.getArrayStore();
        PropertyBlock block = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block, (int)keyId, (Value)Values.of((Object)value), (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator, (boolean)true);
        PropertyRecord record = new PropertyRecord(store.nextId());
        record.addPropertyBlock(block);
        record.setInUse(true);
        StorePropertyCursorTest.updateRecord(store, record);
        return record;
    }

    private static PropertyRecord createTwoPropertyValues(PropertyStore store, int keyId1, Object value1, int keyId2, Object value2) {
        DynamicStringStore stringAllocator = store.getStringStore();
        DynamicArrayStore arrayAllocator = store.getArrayStore();
        PropertyBlock block1 = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block1, (int)keyId1, (Value)Values.of((Object)value1), (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator, (boolean)true);
        PropertyBlock block2 = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block2, (int)keyId2, (Value)Values.of((Object)value2), (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator, (boolean)true);
        PropertyRecord record = new PropertyRecord(store.nextId());
        record.addPropertyBlock(block1);
        if (block1.getSize() + block2.getSize() <= 32) {
            record.addPropertyBlock(block2);
        } else {
            PropertyRecord nextRecord = new PropertyRecord(store.nextId());
            record.setNextProp(nextRecord.getId());
            nextRecord.addPropertyBlock(block2);
            nextRecord.setPrevProp(record.getId());
            nextRecord.setInUse(true);
            StorePropertyCursorTest.updateRecord(store, nextRecord);
        }
        record.setInUse(true);
        StorePropertyCursorTest.updateRecord(store, record);
        return record;
    }

    private static void markDynamicRecordsNotInUse(int keyId, PropertyRecord record, PropertyStore store, int ... dynamicRecordIndexes) {
        PropertyBlock propertyBlock = record.getPropertyBlock(keyId);
        store.ensureHeavy(propertyBlock);
        List valueRecords = propertyBlock.getValueRecords();
        for (int index : dynamicRecordIndexes) {
            DynamicRecord dynamicRecord = (DynamicRecord)valueRecords.get(index);
            dynamicRecord.setInUse(false);
        }
        StorePropertyCursorTest.updateRecord(store, record);
    }

    private static List<Object> asPropertyValuesList(StorePropertyCursor cursor) {
        ArrayList<Object> values = new ArrayList<Object>();
        while (cursor.next()) {
            values.add(cursor.value().asObjectCopy());
        }
        return values;
    }

    private static <T extends AbstractBaseRecord> void updateRecord(RecordStore<T> store, T record) {
        store.updateRecord(record);
        store.setHighestPossibleIdInUse(record.getId());
    }

    public static class PropertyChains
    extends PropertyStoreBasedTestSupport {
        @Test
        public void readPropertyChainWithMultipleEntries() {
            int propertyKeyId = 42;
            Object[] propertyValues = new Object[]{"1", "2", 3, 4, 5L, 6L, Character.valueOf('7'), Character.valueOf('8'), "9 and 10"};
            long firstPropertyId = StorePropertyCursorTest.firstIdOf(StorePropertyCursorTest.createPropertyChain(PropertyChains.propertyStore, propertyKeyId, propertyValues));
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(firstPropertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                List valuesFromCursor = StorePropertyCursorTest.asPropertyValuesList(cursor);
                Assert.assertEquals(Arrays.asList(propertyValues), (Object)valuesFromCursor);
            }
        }

        @Test
        public void callNextAfterReadingPropertyChain() {
            int propertyKeyId = 42;
            long firstPropertyId = StorePropertyCursorTest.firstIdOf(StorePropertyCursorTest.createPropertyChain(PropertyChains.propertyStore, propertyKeyId, new Object[]{"1", "2"}));
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(firstPropertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((Object)Values.of((Object)"1"), (Object)cursor.value());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((Object)Values.of((Object)"2"), (Object)cursor.value());
                Assert.assertFalse((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
        }

        @Test
        public void skipUnusedRecordsInChain() {
            int propertyKeyId = 42;
            Object[] propertyValues = new Object[]{"1", "2", 3, 4, 5L, 6L, Character.valueOf('7'), Character.valueOf('8'), "9 and 10"};
            List propertyChain = StorePropertyCursorTest.createPropertyChain(PropertyChains.propertyStore, propertyKeyId, propertyValues);
            long firstPropertyId = StorePropertyCursorTest.firstIdOf(propertyChain);
            StorePropertyCursorTest.markPropertyRecordsNoInUse(PropertyChains.propertyStore, StorePropertyCursorTest.idsOf(propertyChain, 1, 2, 4));
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(firstPropertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                List valuesFromCursor = StorePropertyCursorTest.asPropertyValuesList(cursor);
                Assert.assertEquals(Arrays.asList("1", 3, 5L, Character.valueOf('7'), "9 and 10"), (Object)valuesFromCursor);
            }
        }

        @Test
        public void skipUnusedConsecutiveRecordsInChain() {
            int propertyKeyId = 42;
            Object[] propertyValues = new Object[]{"1", "2", 3, 4, 5L, 6L, Character.valueOf('7'), Character.valueOf('8'), "9 and 10"};
            List propertyChain = StorePropertyCursorTest.createPropertyChain(PropertyChains.propertyStore, propertyKeyId, propertyValues);
            long firstPropertyId = StorePropertyCursorTest.firstIdOf(propertyChain);
            StorePropertyCursorTest.markPropertyRecordsNoInUse(PropertyChains.propertyStore, StorePropertyCursorTest.idsOf(propertyChain, 2, 1, 3));
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(firstPropertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                List valuesFromCursor = StorePropertyCursorTest.asPropertyValuesList(cursor);
                Assert.assertEquals(Arrays.asList("1", "2", 6L, Character.valueOf('7'), Character.valueOf('8'), "9 and 10"), (Object)valuesFromCursor);
            }
        }

        @Test
        public void skipAllRecordsWhenWholeChainNotInUse() {
            int propertyKeyId = 42;
            Object[] propertyValues = new Object[]{"1", "2", 3, 4, 5L, 6L, Character.valueOf('7'), Character.valueOf('8'), "9 and 10"};
            List propertyChain = StorePropertyCursorTest.createPropertyChain(PropertyChains.propertyStore, propertyKeyId, propertyValues);
            long firstPropertyId = StorePropertyCursorTest.firstIdOf(propertyChain);
            int[] recordIds = StorePropertyCursorTest.idsOf(propertyChain, 0, 1, propertyValues.length);
            StorePropertyCursorTest.markPropertyRecordsNoInUse(PropertyChains.propertyStore, recordIds);
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(firstPropertyId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                List valuesFromCursor = StorePropertyCursorTest.asPropertyValuesList(cursor);
                Assert.assertEquals(Collections.emptyList(), (Object)valuesFromCursor);
            }
        }

        @Test
        public void readPropertyChainWithLongStringDynamicRecordsNotInUse() {
            int keyId = 42;
            Object[] values = new Object[]{RandomStringUtils.randomAscii((int)255), RandomStringUtils.randomAscii((int)255), RandomStringUtils.randomAscii((int)255)};
            List propertyChain = StorePropertyCursorTest.createPropertyChain(PropertyChains.propertyStore, keyId, values);
            long chainStartId = StorePropertyCursorTest.firstIdOf(propertyChain);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, (PropertyRecord)propertyChain.get(1), PropertyChains.propertyStore, new int[]{2});
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(chainStartId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                List valuesFromCursor = StorePropertyCursorTest.asPropertyValuesList(cursor);
                Assert.assertEquals(Arrays.asList(values), (Object)valuesFromCursor);
            }
        }

        @Test
        public void readPropertyValueWhenFirstLongStringDynamicRecordIsNotInUse() {
            int keyId = 1;
            String value = RandomStringUtils.randomAscii((int)255);
            PropertyRecord record = StorePropertyCursorTest.createSinglePropertyValue(PropertyChains.propertyStore, keyId, value);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, record, PropertyChains.propertyStore, new int[]{0});
            this.verifyPropertyValue(value, record.getId());
        }

        @Test
        public void readPropertyValueWhenSomeLongStringDynamicRecordsAreNotInUse() {
            int keyId = 1;
            String value = RandomStringUtils.randomAscii((int)1000);
            PropertyRecord record = StorePropertyCursorTest.createSinglePropertyValue(PropertyChains.propertyStore, keyId, value);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, record, PropertyChains.propertyStore, new int[]{1, 3, 5, 7});
            this.verifyPropertyValue(value, record.getId());
        }

        @Test
        public void readPropertyValueWhenAllLongStringDynamicRecordsAreNotInUse() {
            int keyId = 1;
            String value = RandomStringUtils.randomAscii((int)255);
            PropertyRecord record = StorePropertyCursorTest.createSinglePropertyValue(PropertyChains.propertyStore, keyId, value);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, record, PropertyChains.propertyStore, new int[]{0, 1, 2});
            this.verifyPropertyValue(value, record.getId());
        }

        @Test
        public void readPropertyValueWhenAllLongArrayDynamicRecordsAreNotInUse() {
            int keyId = 1;
            byte[] value = RandomUtils.nextBytes((int)320);
            PropertyRecord record = StorePropertyCursorTest.createSinglePropertyValue(PropertyChains.propertyStore, keyId, value);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, record, PropertyChains.propertyStore, new int[]{0, 1, 2});
            this.verifyPropertyValue(value, record.getId());
        }

        @Test
        public void readPropertyChainWithLongArrayDynamicRecordsNotInUse() {
            int keyId = 42;
            Object[] values = new Object[]{RandomUtils.nextBytes((int)1024), RandomUtils.nextBytes((int)1024), RandomUtils.nextBytes((int)1024)};
            List propertyChain = StorePropertyCursorTest.createPropertyChain(PropertyChains.propertyStore, keyId, values);
            long chainStartId = StorePropertyCursorTest.firstIdOf(propertyChain);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, (PropertyRecord)propertyChain.get(1), PropertyChains.propertyStore, new int[]{2});
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(chainStartId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                List valuesFromCursor = StorePropertyCursorTest.asPropertyValuesList(cursor);
                for (int i = 0; i < valuesFromCursor.size(); ++i) {
                    Object value = valuesFromCursor.get(i);
                    Assert.assertArrayEquals((byte[])((byte[])values[i]), (byte[])((byte[])value));
                }
            }
        }

        @Test
        public void readPropertyValueWhenFirstLongArrayDynamicRecordIsNotInUse() {
            int keyId = 1;
            byte[] value = RandomUtils.nextBytes((int)1024);
            PropertyRecord record = StorePropertyCursorTest.createSinglePropertyValue(PropertyChains.propertyStore, keyId, value);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, record, PropertyChains.propertyStore, new int[]{0});
            this.verifyPropertyValue(value, record.getId());
        }

        @Test
        public void readPropertyValueWhenSomeLongArrayDynamicRecordsAreNotInUse() {
            int keyId = 1;
            byte[] value = RandomUtils.nextBytes((int)1024);
            PropertyRecord record = StorePropertyCursorTest.createSinglePropertyValue(PropertyChains.propertyStore, keyId, value);
            StorePropertyCursorTest.markDynamicRecordsNotInUse(keyId, record, PropertyChains.propertyStore, new int[]{1, 3, 5, 7});
            this.verifyPropertyValue(value, record.getId());
        }

        private void verifyPropertyValue(String expectedValue, long recordId) {
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(recordId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((Object)Values.of((Object)expectedValue), (Object)cursor.value());
                Assert.assertFalse((boolean)cursor.next());
            }
        }

        private void verifyPropertyValue(byte[] expectedValue, long recordId) {
            try (StorePropertyCursor cursor = StorePropertyCursorTest.newStorePropertyCursor(PropertyChains.propertyStore);){
                cursor.init(recordId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.value().equals(expectedValue));
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class CursorReuse
    extends PropertyStoreBasedTestSupport {
        @Parameterized.Parameter(value=0)
        public Object expectedValue;
        @Parameterized.Parameter(value=1)
        public PropertyType type;

        @Parameterized.Parameters(name="value={0} of type={1}")
        public static List<Object[]> parameters() {
            return PARAMETERS;
        }

        @Test
        public void shouldReuseCorrectlyCursor() {
            PropertyItem item;
            int keyId = 11;
            Object expectedValue = StorePropertyCursorTest.actualValue(this.expectedValue);
            long recordId = StorePropertyCursorTest.createSinglePropertyValue(CursorReuse.propertyStore, keyId, expectedValue).getId();
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(CursorReuse.propertyStore);
            try (StorePropertyCursor cursor = storePropertyCursor.init(recordId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);){
                Assert.assertTrue((boolean)cursor.next());
                item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue, item);
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = storePropertyCursor.init(recordId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
            var7_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue, item);
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var7_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var7_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var7_6.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TwoValueProperties
    extends PropertyStoreBasedTestSupport {
        @Parameterized.Parameter(value=0)
        public Object expectedValue1;
        @Parameterized.Parameter(value=1)
        public PropertyType type1;
        @Parameterized.Parameter(value=2)
        public Object expectedValue2;
        @Parameterized.Parameter(value=3)
        public PropertyType type2;

        @Parameterized.Parameters(name="value={0} of type={1} and value={2} of type={3}")
        public static Collection<Object[]> parameters() {
            ArrayList<Object[]> combinations = new ArrayList<Object[]>();
            for (int i = 0; i < PARAMETERS.size(); ++i) {
                Object[] current = (Object[])PARAMETERS.get(i);
                for (Object[] other : PARAMETERS) {
                    Object[] objects = new Object[]{current[0], current[1], other[0], other[1]};
                    combinations.add(objects);
                }
            }
            return combinations;
        }

        @Test
        public void shouldReturnAPropertyBySkippingOne() {
            int keyId1 = 11;
            int keyId2 = 22;
            Object expectedValue1 = StorePropertyCursorTest.actualValue(this.expectedValue1);
            Object expectedValue2 = StorePropertyCursorTest.actualValue(this.expectedValue2);
            long recordId = StorePropertyCursorTest.createTwoPropertyValues(TwoValueProperties.propertyStore, keyId1, expectedValue1, keyId2, expectedValue2).getId();
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(TwoValueProperties.propertyStore);
            try (StorePropertyCursor cursor = storePropertyCursor.init(recordId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);){
                Assert.assertTrue((boolean)cursor.next());
                PropertyItem item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId1, (long)item.propertyKeyId());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)keyId2, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue2, item);
                Assert.assertFalse((boolean)cursor.next());
            }
        }

        @Test
        public void shouldReturnTwoProperties() {
            int keyId1 = 11;
            int keyId2 = 22;
            Object expectedValue1 = StorePropertyCursorTest.actualValue(this.expectedValue1);
            Object expectedValue2 = StorePropertyCursorTest.actualValue(this.expectedValue2);
            long recordId = StorePropertyCursorTest.createTwoPropertyValues(TwoValueProperties.propertyStore, keyId1, expectedValue1, keyId2, expectedValue2).getId();
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(TwoValueProperties.propertyStore);
            try (StorePropertyCursor cursor = storePropertyCursor.init(recordId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);){
                Assert.assertTrue((boolean)cursor.next());
                PropertyItem item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId1, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue1, item);
                Assert.assertTrue((boolean)cursor.next());
                item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId2, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue2, item);
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SingleValueProperties
    extends PropertyStoreBasedTestSupport {
        @Parameterized.Parameter(value=0)
        public Object expectedValue;
        @Parameterized.Parameter(value=1)
        public PropertyType type;

        @Parameterized.Parameters(name="value={0} of type={1}")
        public static List<Object[]> parameters() {
            return PARAMETERS;
        }

        @Test
        public void shouldReturnAProperty() {
            int keyId = 11;
            Object expectedValue = StorePropertyCursorTest.actualValue(this.expectedValue);
            long recordId = StorePropertyCursorTest.createSinglePropertyValue(SingleValueProperties.propertyStore, keyId, expectedValue).getId();
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(SingleValueProperties.propertyStore);
            try (StorePropertyCursor cursor = storePropertyCursor.init(recordId, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);){
                Assert.assertTrue((boolean)cursor.next());
                PropertyItem item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue, item);
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    public static class PropertyStoreBasedTestSupport {
        @ClassRule
        public static EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
        @ClassRule
        public static PageCacheRule pageCacheRule = new PageCacheRule();
        private static PageCache pageCache;
        private static NeoStores neoStores;
        protected static PropertyStore propertyStore;

        @BeforeClass
        public static void setUp() {
            File storeDir;
            pageCache = pageCacheRule.getPageCache(fsRule.get());
            EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)fsRule.get();
            if (fs.isDirectory(storeDir = new File("store").getAbsoluteFile())) {
                fs.deleteRecursively(storeDir);
            }
            fs.mkdirs(storeDir);
            Config config = Config.defaults();
            DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)fs);
            NullLogProvider logProvider = NullLogProvider.getInstance();
            neoStores = new StoreFactory(storeDir, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY).openAllNeoStores(true);
            propertyStore = neoStores.getPropertyStore();
        }

        @AfterClass
        public static void tearDown() {
            neoStores.close();
            pageCache.close();
        }

        @Test
        public void ignore() {
        }
    }

    public static class ErrorTest {
        private final NeoStores neoStores = MockedNeoStores.basicMockedNeoStores();
        private final PropertyStore propertyStore = this.neoStores.getPropertyStore();
        private final Consumer<StorePropertyCursor> cache = (Consumer)Mockito.mock(Consumer.class);

        public ErrorTest() {
            RecordCursor recordCursor = MockedNeoStores.mockedRecordCursor();
            try {
                Mockito.when((Object)recordCursor.next()).thenReturn((Object)true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Mockito.when((Object)recordCursor.get()).thenReturn((Object)new PropertyRecord(42L));
            Mockito.when((Object)this.propertyStore.newRecordCursor((AbstractBaseRecord)ArgumentMatchers.any(PropertyRecord.class))).thenReturn(recordCursor);
        }

        @Test
        public void shouldReturnTheCursorToTheCacheOnClose() {
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(this.propertyStore, this.cache);
            storePropertyCursor.init(0L, LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
            storePropertyCursor.close();
            ((Consumer)Mockito.verify(this.cache, (VerificationMode)Mockito.times((int)1))).accept(storePropertyCursor);
        }
    }

    private static class BigProperty {
        private final Object actualValue;
        private final String toStringForUnitTest;

        BigProperty(Object value, String toStringForUnitTest) {
            this.actualValue = value;
            this.toStringForUnitTest = toStringForUnitTest;
        }

        Object value() {
            return this.actualValue;
        }

        public String toString() {
            return this.toStringForUnitTest;
        }
    }
}

