/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.index.AbstractGBPTreeFileUtilTest;
import org.neo4j.kernel.impl.index.GBPTreeFileUtil;
import org.neo4j.kernel.impl.index.labelscan.GBPTreePageCacheFileUtil;
import org.neo4j.kernel.impl.index.schema.GBPTreeFileSystemFileUtil;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class GBPTreeFileUtilTest
extends AbstractGBPTreeFileUtilTest {
    @ClassRule
    public static PageCacheAndDependenciesRule pageCacheAndDependenciesRule = new PageCacheAndDependenciesRule(DefaultFileSystemRule::new, GBPTreeFileUtilTest.class);
    private static FileSystemAbstraction fs;
    private static TestDirectory directory;
    @Parameterized.Parameter
    public GBPTreeFileUtil gbpTreeFileUtil;

    @BeforeClass
    public static void extractFileSystem() {
        fs = pageCacheAndDependenciesRule.fileSystem();
        directory = pageCacheAndDependenciesRule.directory();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<GBPTreeFileUtil> fileUtils() {
        return Arrays.asList(new GBPTreePageCacheFileUtil(pageCacheAndDependenciesRule.pageCache()), new GBPTreeFileSystemFileUtil(pageCacheAndDependenciesRule.fileSystem()));
    }

    @Override
    protected GBPTreeFileUtil getGBPTreeFileUtil() {
        return this.gbpTreeFileUtil;
    }

    @Override
    protected File existingFile(String fileName) throws IOException {
        File file = directory.file(fileName);
        fs.create(file).close();
        return file;
    }

    @Override
    protected File nonExistingFile(String fileName) {
        return directory.file(fileName);
    }

    @Override
    protected File nonExistingDirectory(String directoryName) {
        return new File(directory.absolutePath(), directoryName);
    }

    @Override
    protected void assertFileDoesNotExist(File file) {
        Assert.assertFalse((boolean)fs.fileExists(file));
    }

    @Override
    protected void assertDirectoryExist(File directory) {
        Assert.assertTrue((boolean)fs.fileExists(directory));
        Assert.assertTrue((boolean)fs.isDirectory(directory));
    }
}

