/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.IntFunction;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;

public class LazyInstanceSelectorTest {
    @Test
    public void shouldInstantiateLazilyOnFirstSelect() {
        IntFunction factory = (IntFunction)Mockito.mock(IntFunction.class);
        Mockito.when(factory.apply(ArgumentMatchers.anyInt())).then(invocationOnMock -> String.valueOf((Integer)invocationOnMock.getArgument(0)));
        LazyInstanceSelector selector = new LazyInstanceSelector((Object[])new String[5], factory);
        for (int slot = 0; slot < 5; ++slot) {
            for (int candidate = 0; candidate < 5; ++candidate) {
                if (candidate < slot) {
                    ((IntFunction)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).apply(candidate);
                    selector.select(candidate);
                    ((IntFunction)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).apply(candidate);
                    continue;
                }
                if (candidate == slot) {
                    ((IntFunction)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)0))).apply(candidate);
                    selector.select(candidate);
                    ((IntFunction)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).apply(candidate);
                    continue;
                }
                Assert.assertNull((Object)selector.getIfInstantiated(candidate));
            }
        }
    }

    @Test
    public void shouldPerformActionOnAll() {
        IntFunction factory = (IntFunction)Mockito.mock(IntFunction.class);
        Mockito.when(factory.apply(ArgumentMatchers.anyInt())).then(invocationOnMock -> String.valueOf((Integer)invocationOnMock.getArgument(0)));
        LazyInstanceSelector selector = new LazyInstanceSelector((Object[])new String[5], factory);
        selector.select(1);
        ThrowingConsumer consumer = (ThrowingConsumer)Mockito.mock(ThrowingConsumer.class);
        selector.forAll(consumer);
        for (int slot = 0; slot < 5; ++slot) {
            ((ThrowingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)String.valueOf(slot));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    public void shouldCloseAllInstantiated() {
        IntFunction factory = (IntFunction)Mockito.mock(IntFunction.class);
        Mockito.when(factory.apply(ArgumentMatchers.anyInt())).then(invocationOnMock -> String.valueOf((Integer)invocationOnMock.getArgument(0)));
        LazyInstanceSelector selector = new LazyInstanceSelector((Object[])new String[5], factory);
        selector.select(1);
        selector.select(3);
        ThrowingConsumer consumer = (ThrowingConsumer)Mockito.mock(ThrowingConsumer.class);
        selector.close(consumer);
        ((ThrowingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"1");
        ((ThrowingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"3");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    public void shouldPreventInstantiationAfterClose() {
        IntFunction factory = (IntFunction)Mockito.mock(IntFunction.class);
        Mockito.when(factory.apply(ArgumentMatchers.anyInt())).then(invocationOnMock -> String.valueOf((Integer)invocationOnMock.getArgument(0)));
        LazyInstanceSelector selector = new LazyInstanceSelector((Object[])new String[5], factory);
        selector.select(1);
        selector.select(3);
        selector.close((ThrowingConsumer)Mockito.mock(ThrowingConsumer.class));
        try {
            selector.select(0);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

