/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.ThrowingAction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.test.assertion.Assert;

public class KernelTokenArgumentTest {
    private KernelToken token = new KernelToken((StoreReadLayer)Mockito.mock(StoreReadLayer.class), (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class));

    @Test
    public void labelGetOrCreateForName() {
        this.assertIllegalToken((ThrowingAction<KernelException>)((ThrowingAction)() -> this.token.labelGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingAction<KernelException>)((ThrowingAction)() -> this.token.labelGetOrCreateForName("")));
    }

    @Test
    public void propertyKeyGetOrCreateForName() {
        this.assertIllegalToken((ThrowingAction<KernelException>)((ThrowingAction)() -> this.token.propertyKeyGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingAction<KernelException>)((ThrowingAction)() -> this.token.propertyKeyGetOrCreateForName("")));
    }

    @Test
    public void relationshipTypeGetOrCreateForName() {
        this.assertIllegalToken((ThrowingAction<KernelException>)((ThrowingAction)() -> this.token.relationshipTypeGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingAction<KernelException>)((ThrowingAction)() -> this.token.relationshipTypeGetOrCreateForName("")));
    }

    private void assertIllegalToken(ThrowingAction<KernelException> f) {
        Assert.assertException(f, IllegalTokenNameException.class);
    }
}

