/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.MockStore;
import org.neo4j.kernel.impl.newapi.NodeValueClientFilter;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeValueClientFilterTest
implements IndexProgressor,
IndexProgressor.NodeValueClient {
    @Rule
    public final MockStore store = new MockStore(new DefaultCursors());
    private final List<Event> events = new ArrayList<Event>();
    private final DefaultCursors cursors = new DefaultCursors();

    @Test
    public void shouldAcceptAllNodesOnNoFilters() {
        this.store.node(17L, -1L, false, -1L, 0L);
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[0]);
        filter.next();
        Assert.assertTrue((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, new Event.Node(17L, null), Event.CLOSE);
    }

    @Test
    public void shouldRejectNodeNotInUse() {
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertFalse((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, Event.CLOSE);
    }

    @Test
    public void shouldRejectNodeWithNoProperties() {
        this.store.node(17L, -1L, false, -1L, 0L);
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertFalse((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, Event.CLOSE);
    }

    @Test
    public void shouldAcceptNodeWithMatchingProperty() {
        Mockito.when((Object)this.store.ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        this.store.node(17L, 1L, false, -1L, 0L);
        this.store.property(1L, -1L, -1L, MockStore.block(12, (Value)Values.stringValue((String)"hello")));
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertTrue((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, new Event.Node(17L, null), Event.CLOSE);
    }

    @Test
    public void shouldNotAcceptNodeWithoutMatchingProperty() {
        Mockito.when((Object)this.store.ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        this.store.node(17L, 1L, false, -1L, 0L);
        this.store.property(1L, -1L, -1L, MockStore.block(7, (Value)Values.stringValue((String)"wrong")));
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertFalse((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, Event.CLOSE);
    }

    private NodeValueClientFilter initializeFilter(IndexQuery ... filters) {
        NodeValueClientFilter filter = new NodeValueClientFilter((IndexProgressor.NodeValueClient)this, this.cursors.allocateNodeCursor(), this.cursors.allocatePropertyCursor(), (Read)this.store, filters);
        filter.initialize(SchemaIndexDescriptorFactory.forLabel((int)11, (int[])new int[0]), (IndexProgressor)this, null);
        return filter;
    }

    private void assertEvents(Event ... expected) {
        Assert.assertEquals(Arrays.asList(expected), this.events);
    }

    private Event.Initialize initialize(int ... keys) {
        return new Event.Initialize(this, keys);
    }

    public void initialize(SchemaIndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] queries) {
        this.events.add(new Event.Initialize(progressor, descriptor.schema().getPropertyIds()));
    }

    public boolean acceptNode(long reference, Value[] values) {
        this.events.add(new Event.Node(reference, values));
        return true;
    }

    public boolean needsValues() {
        return true;
    }

    public boolean next() {
        this.events.add(Event.NEXT);
        return true;
    }

    public void close() {
        this.events.add(Event.CLOSE);
    }

    private static abstract class Event {
        static final Event CLOSE = new Event(){

            public String toString() {
                return "CLOSE";
            }
        };
        static final Event NEXT = new Event(){

            public String toString() {
                return "NEXT";
            }
        };

        private Event() {
        }

        public final boolean equals(Object other) {
            return this.toString().equals(other.toString());
        }

        public final int hashCode() {
            return this.toString().hashCode();
        }

        static class Node
        extends Event {
            final long reference;
            final Value[] values;

            Node(long reference, Value[] values) {
                this.reference = reference;
                this.values = values;
            }

            public String toString() {
                return "Node(" + this.reference + "," + Arrays.toString(this.values) + ")";
            }
        }

        static class Initialize
        extends Event {
            final transient IndexProgressor progressor;
            final int[] keys;

            Initialize(IndexProgressor progressor, int[] keys) {
                this.progressor = progressor;
                this.keys = keys;
            }

            public String toString() {
                return "INITIALIZE(" + Arrays.toString(this.keys) + ")";
            }
        }
    }
}

