/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.scheduler.JobScheduler;

public class CentralJobSchedulerTest {
    private final AtomicInteger invocations = new AtomicInteger();
    private final LifeSupport life = new LifeSupport();
    private final CentralJobScheduler scheduler = (CentralJobScheduler)this.life.add((Lifecycle)new CentralJobScheduler());
    private final Runnable countInvocationsJob = this.invocations::incrementAndGet;

    @After
    public void stopScheduler() {
        this.life.shutdown();
    }

    @Test(timeout=10000L)
    public void shouldRunRecurringJob() throws Throwable {
        long period = 10L;
        int count = 5;
        this.life.start();
        this.scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitInvocationCount(count);
        this.scheduler.shutdown();
        int actualInvocations = this.invocations.get();
        Thread.sleep(period * 5L);
        Assert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)actualInvocations));
    }

    @Test
    public void shouldCancelRecurringJob() throws Exception {
        long period = 2L;
        this.life.start();
        JobScheduler.JobHandle jobHandle = this.scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        jobHandle.cancel(false);
        try {
            jobHandle.waitTermination();
            Assert.fail((String)"Task should be terminated");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        int recorded = this.invocations.get();
        Thread.sleep(period * 100L);
        Assert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(recorded))).and(Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(recorded + 1))));
    }

    @Test
    public void shouldRunWithDelay() throws Throwable {
        this.life.start();
        AtomicLong runTime = new AtomicLong();
        CountDownLatch latch = new CountDownLatch(1);
        long time = System.nanoTime();
        this.scheduler.schedule(new JobScheduler.Group("group"), () -> {
            runTime.set(System.nanoTime());
            latch.countDown();
        }, 100L, TimeUnit.MILLISECONDS);
        latch.await();
        Assert.assertTrue((time + TimeUnit.MILLISECONDS.toNanos(100L) <= runTime.get() ? 1 : 0) != 0);
    }

    @Test
    public void longRunningScheduledJobsMustNotDelayOtherLongRunningJobs() {
        int i;
        this.life.start();
        ArrayList<JobScheduler.JobHandle> handles = new ArrayList<JobScheduler.JobHandle>(30);
        JobScheduler.Group group = new JobScheduler.Group("test");
        AtomicLong startedCounter = new AtomicLong();
        BinaryLatch blockLatch = new BinaryLatch();
        Runnable task = () -> {
            startedCounter.incrementAndGet();
            blockLatch.await();
        };
        for (i = 0; i < 10; ++i) {
            handles.add(this.scheduler.schedule(group, task, 0L, TimeUnit.MILLISECONDS));
        }
        for (i = 0; i < 10; ++i) {
            handles.add(this.scheduler.scheduleRecurring(group, task, Integer.MAX_VALUE, TimeUnit.MILLISECONDS));
        }
        for (i = 0; i < 10; ++i) {
            handles.add(this.scheduler.scheduleRecurring(group, task, 0L, Integer.MAX_VALUE, TimeUnit.MILLISECONDS));
        }
        long deadline = TimeUnit.SECONDS.toNanos(10L) + System.nanoTime();
        do {
            if (startedCounter.get() != (long)handles.size()) continue;
            blockLatch.release();
            for (JobScheduler.JobHandle handle : handles) {
                handle.cancel(false);
            }
            return;
        } while (System.nanoTime() < deadline);
        Assert.fail((String)("Only managed to start " + startedCounter.get() + " tasks in 10 seconds, when " + handles.size() + " was expected."));
    }

    @Test
    public void shouldNotifyCancelListeners() {
        CentralJobScheduler centralJobScheduler = new CentralJobScheduler();
        centralJobScheduler.init();
        AtomicBoolean halted = new AtomicBoolean();
        Runnable job = () -> {
            while (!halted.get()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            }
        };
        JobScheduler.JobHandle handle = centralJobScheduler.schedule(JobScheduler.Groups.indexPopulation, job);
        handle.registerCancelListener(mayBeInterrupted -> halted.set(true));
        handle.cancel(false);
        Assert.assertTrue((boolean)halted.get());
        centralJobScheduler.shutdown();
    }

    @Test(timeout=10000L)
    public void waitTerminationOnDelayedJobMustWaitUntilJobCompletion() throws Exception {
        CentralJobScheduler scheduler = new CentralJobScheduler();
        scheduler.init();
        AtomicBoolean triggered = new AtomicBoolean();
        Runnable job = () -> {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            triggered.set(true);
        };
        JobScheduler.JobHandle handle = scheduler.schedule(JobScheduler.Groups.indexPopulation, job, 10L, TimeUnit.MILLISECONDS);
        handle.waitTermination();
        Assert.assertTrue((boolean)triggered.get());
    }

    @Test(timeout=10000L)
    public void scheduledTasksThatThrowsMustPropagateException() throws Exception {
        CentralJobScheduler scheduler = new CentralJobScheduler();
        scheduler.init();
        RuntimeException boom = new RuntimeException("boom");
        AtomicInteger triggerCounter = new AtomicInteger();
        Runnable job = () -> {
            triggerCounter.incrementAndGet();
            throw boom;
        };
        JobScheduler.JobHandle handle = scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, job, 1L, TimeUnit.MILLISECONDS);
        try {
            handle.waitTermination();
            Assert.fail((String)"waitTermination should have failed.");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Object)boom));
        }
    }

    @Test(timeout=10000L)
    public void scheduledTasksThatThrowsShouldStop() throws Exception {
        CentralJobScheduler scheduler = new CentralJobScheduler();
        scheduler.init();
        BinaryLatch triggerLatch = new BinaryLatch();
        RuntimeException boom = new RuntimeException("boom");
        AtomicInteger triggerCounter = new AtomicInteger();
        Runnable job = () -> {
            triggerCounter.incrementAndGet();
            triggerLatch.release();
            throw boom;
        };
        scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, job, 1L, TimeUnit.MILLISECONDS);
        triggerLatch.await();
        Thread.sleep(50L);
        Assert.assertThat((Object)triggerCounter.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test(timeout=10000L)
    public void shutDownMustKillCancelledJobs() {
        CentralJobScheduler scheduler = new CentralJobScheduler();
        scheduler.init();
        BinaryLatch startLatch = new BinaryLatch();
        BinaryLatch stopLatch = new BinaryLatch();
        scheduler.schedule(JobScheduler.Groups.indexPopulation, () -> {
            try {
                startLatch.release();
                Thread.sleep(100000L);
            }
            catch (InterruptedException e) {
                stopLatch.release();
                throw new RuntimeException(e);
            }
        });
        startLatch.await();
        scheduler.shutdown();
        stopLatch.await();
    }

    private void awaitFirstInvocation() throws InterruptedException {
        this.awaitInvocationCount(1);
    }

    private void awaitInvocationCount(int count) throws InterruptedException {
        while (this.invocations.get() < count) {
            Thread.sleep(10L);
        }
    }
}

