/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccess;

public class RelationshipGroupGetterTest {
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final PageCacheRule pageCache = new PageCacheRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.pageCache);

    @Test
    public void shouldAbortLoadingGroupChainIfComeTooFar() {
        File dir = new File("dir");
        ((EphemeralFileSystemAbstraction)this.fs.get()).mkdirs(dir);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(dir, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCache.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY);
        try (NeoStores stores = storeFactory.openNeoStores(true, new StoreType[]{StoreType.RELATIONSHIP_GROUP});){
            RecordStore store = (RecordStore)Mockito.spy((Object)stores.getRelationshipGroupStore());
            RelationshipGroupRecord group2 = this.group(0L, 2);
            RelationshipGroupRecord group4 = this.group(1L, 4);
            RelationshipGroupRecord group10 = this.group(2L, 10);
            RelationshipGroupRecord group23 = this.group(3L, 23);
            this.link(group2, group4, group10, group23);
            store.updateRecord((AbstractBaseRecord)group2);
            store.updateRecord((AbstractBaseRecord)group4);
            store.updateRecord((AbstractBaseRecord)group10);
            store.updateRecord((AbstractBaseRecord)group23);
            RelationshipGroupGetter groupGetter = new RelationshipGroupGetter((IdSequence)store);
            NodeRecord node = new NodeRecord(0L, true, group2.getId(), -1L);
            DirectRecordAccess access = new DirectRecordAccess(store, Loaders.relationshipGroupLoader((RecordStore)store));
            RelationshipGroupGetter.RelationshipGroupPosition result = groupGetter.getRelationshipGroup(node, 7, (RecordAccess)access);
            InOrder verification = Mockito.inOrder((Object[])new Object[]{store});
            ((RecordStore)verification.verify((Object)store)).getRecord(ArgumentMatchers.eq((long)group2.getId()), (AbstractBaseRecord)ArgumentMatchers.any(RelationshipGroupRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class));
            ((RecordStore)verification.verify((Object)store)).getRecord(ArgumentMatchers.eq((long)group4.getId()), (AbstractBaseRecord)ArgumentMatchers.any(RelationshipGroupRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class));
            ((RecordStore)verification.verify((Object)store)).getRecord(ArgumentMatchers.eq((long)group10.getId()), (AbstractBaseRecord)ArgumentMatchers.any(RelationshipGroupRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class));
            ((RecordStore)verification.verify((Object)store, Mockito.never())).getRecord(ArgumentMatchers.eq((long)group23.getId()), (AbstractBaseRecord)ArgumentMatchers.any(RelationshipGroupRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class));
            Assert.assertNull((Object)result.group());
            Assert.assertEquals((Object)group4, (Object)result.closestPrevious().forReadingData());
        }
    }

    private void link(RelationshipGroupRecord ... groups) {
        for (int i = 0; i < groups.length; ++i) {
            if (i > 0) {
                groups[i].setPrev(groups[i - 1].getId());
            }
            if (i >= groups.length - 1) continue;
            groups[i].setNext(groups[i + 1].getId());
        }
    }

    private RelationshipGroupRecord group(long id, int type) {
        RelationshipGroupRecord group = new RelationshipGroupRecord(id, type);
        group.setInUse(true);
        return group;
    }
}

