/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.logging.AssertableLogProvider;

public class KernelDiagnosticsTest {
    @Test
    public void shouldPrintDiskUsage() {
        File storeDir = (File)Mockito.mock(File.class);
        Mockito.when((Object)storeDir.getTotalSpace()).thenReturn((Object)100L);
        Mockito.when((Object)storeDir.getFreeSpace()).thenReturn((Object)40L);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        KernelDiagnostics.StoreFiles storeFiles = new KernelDiagnostics.StoreFiles(storeDir);
        storeFiles.dump(logProvider.getLog(this.getClass()).debugLogger());
        logProvider.assertContainsMessageContaining("100 / 40 / 40");
    }

    @Test
    public void shouldCountFileSizeRecursively() {
        File indexFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)indexFile.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)indexFile.getName()).thenReturn((Object)"indexFile");
        Mockito.when((Object)indexFile.length()).thenReturn((Object)1024L);
        File indexDir = (File)Mockito.mock(File.class);
        Mockito.when((Object)indexDir.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)indexDir.listFiles()).thenReturn((Object)new File[]{indexFile});
        Mockito.when((Object)indexDir.getName()).thenReturn((Object)"indexDir");
        File dbFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)dbFile.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)dbFile.getName()).thenReturn((Object)"neostore");
        Mockito.when((Object)dbFile.length()).thenReturn((Object)3072L);
        File storeDir = (File)Mockito.mock(File.class);
        Mockito.when((Object)storeDir.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)storeDir.listFiles()).thenReturn((Object)new File[]{indexDir, dbFile});
        Mockito.when((Object)storeDir.getName()).thenReturn((Object)"storeDir");
        Mockito.when((Object)storeDir.getAbsolutePath()).thenReturn((Object)"/test/storeDir");
        AssertableLogProvider logProvider = new AssertableLogProvider();
        KernelDiagnostics.StoreFiles storeFiles = new KernelDiagnostics.StoreFiles(storeDir);
        storeFiles.dump(logProvider.getLog(this.getClass()).debugLogger());
        logProvider.assertContainsMessageContaining("Total size of store: 4.00 kB");
        logProvider.assertContainsMessageContaining("Total size of mapped files: 3.00 kB");
    }
}

