/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringCollisionValues;

@RunWith(value=Parameterized.class)
public class StringCollisionValuesTest {
    @Rule
    public final RandomRule random = new RandomRule().withConfiguration((Randoms.Configuration)new Randoms.Default(){

        public int stringMaxLength() {
            return 65535;
        }
    });
    @Parameterized.Parameter(value=0)
    public NumberArrayFactory factory;

    @Parameterized.Parameters
    public static Collection<NumberArrayFactory> data() {
        return Arrays.asList(NumberArrayFactory.HEAP, NumberArrayFactory.OFF_HEAP, NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, NumberArrayFactory.CHUNKED_FIXED_SIZE);
    }

    @Test
    public void shouldStoreAndLoadStrings() {
        try (StringCollisionValues values = new StringCollisionValues(this.factory, 10000L);){
            int i;
            long[] offsets = new long[100];
            String[] strings = new String[offsets.length];
            for (i = 0; i < offsets.length; ++i) {
                String string = this.random.string();
                offsets[i] = values.add((Object)string);
                strings[i] = string;
            }
            for (i = 0; i < offsets.length; ++i) {
                Assert.assertEquals((Object)strings[i], (Object)values.get(offsets[i]));
            }
        }
    }
}

