/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class GraphDatabaseFacadeTest {
    private final GraphDatabaseFacade.SPI spi = (GraphDatabaseFacade.SPI)Mockito.mock(GraphDatabaseFacade.SPI.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final GraphDatabaseFacade graphDatabaseFacade = new GraphDatabaseFacade();
    private GraphDatabaseQueryService queryService;
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        EditionModule editionModule = (EditionModule)Mockito.mock(EditionModule.class);
        Statement statement = (Statement)Mockito.mock(Statement.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ThreadToStatementContextBridge contextBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Mockito.when((Object)this.spi.queryService()).thenReturn((Object)this.queryService);
        Mockito.when((Object)this.spi.resolver()).thenReturn((Object)resolver);
        Mockito.when((Object)resolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)contextBridge);
        Guard guard = (Guard)Mockito.mock(Guard.class);
        Mockito.when((Object)resolver.resolveDependency(Guard.class)).thenReturn((Object)guard);
        Mockito.when((Object)contextBridge.get()).thenReturn((Object)statement);
        Config config = Config.defaults();
        Mockito.when((Object)resolver.resolveDependency(Config.class)).thenReturn((Object)config);
        this.graphDatabaseFacade.init(editionModule, this.spi, guard, contextBridge, config, (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class));
    }

    @Test
    public void beginTransactionWithCustomTimeout() {
        this.graphDatabaseFacade.beginTx(10L, TimeUnit.MILLISECONDS);
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED, 10L);
    }

    @Test
    public void beginTransaction() {
        this.graphDatabaseFacade.beginTx();
        long timeout = ((Duration)Config.defaults().get(GraphDatabaseSettings.transaction_timeout)).toMillis();
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED, timeout);
    }

    @Test
    public void executeQueryWithCustomTimeoutShouldStartTransactionWithRequestedTimeout() {
        this.graphDatabaseFacade.execute("create (n)", 157L, TimeUnit.SECONDS);
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED, TimeUnit.SECONDS.toMillis(157L));
        this.graphDatabaseFacade.execute("create (n)", new HashMap(), 247L, TimeUnit.MINUTES);
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi)).beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED, TimeUnit.MINUTES.toMillis(247L));
    }

    @Test
    public void executeQueryStartDefaultTransaction() {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        TopLevelTransaction transaction = new TopLevelTransaction(kernelTransaction, null);
        Mockito.when((Object)this.queryService.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED)).thenReturn((Object)transaction);
        this.graphDatabaseFacade.execute("create (n)");
        this.graphDatabaseFacade.execute("create (n)", new HashMap());
        long timeout = ((Duration)Config.defaults().get(GraphDatabaseSettings.transaction_timeout)).toMillis();
        ((GraphDatabaseFacade.SPI)Mockito.verify((Object)this.spi, (VerificationMode)Mockito.times((int)2))).beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED, timeout);
    }
}

