/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.StringsLibrary;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class StringLayoutTestUtil
extends LayoutTestUtil<StringSchemaKey, NativeSchemaValue> {
    StringLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(StringSchemaKey key1, StringSchemaKey key2) {
        return UTF8StringValue.byteArrayCompare((byte[])Arrays.copyOf(key1.bytes, key1.bytesLength), (byte[])Arrays.copyOf(key2.bytes, key2.bytesLength));
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.generateAddUpdatesFor(StringsLibrary.STRINGS);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(StringsLibrary.STRINGS);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        ArrayList<String> duplicates = new ArrayList<String>(Arrays.asList(StringsLibrary.STRINGS));
        duplicates.addAll(Arrays.asList(StringsLibrary.STRINGS));
        return this.generateAddUpdatesFor(duplicates.toArray());
    }

    @Override
    protected Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        String candidate;
        while (!uniqueCompareValues.add(candidate = random.string())) {
        }
        TextValue result = Values.stringValue((String)candidate);
        uniqueValues.add((Value)result);
        return result;
    }
}

