/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.Clocks;

public class RWLockTest {
    private static final long TEST_TIMEOUT_MILLIS = 10000L;
    private static ExecutorService executor;

    @BeforeClass
    public static void initExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void stopExecutor() throws InterruptedException {
        executor.shutdown();
        executor.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @Test
    public void assertWriteLockDoesNotLeakMemory() {
        RagManager ragManager = new RagManager();
        LockResource resource = new LockResource((ResourceType)ResourceTypes.NODE, 0L);
        RWLock lock = this.createRWLock(ragManager, resource);
        Transaction tx1 = (Transaction)Mockito.mock(Transaction.class);
        lock.mark();
        lock.acquireWriteLock(LockTracer.NONE, (Object)tx1);
        lock.mark();
        Assert.assertEquals((Object)1, (Object)lock.getTxLockElementCount());
        lock.releaseWriteLock((Object)tx1);
        Assert.assertEquals((Object)0, (Object)lock.getTxLockElementCount());
    }

    @Test
    public void assertReadLockDoesNotLeakMemory() {
        RagManager ragManager = new RagManager();
        LockResource resource = new LockResource((ResourceType)ResourceTypes.NODE, 0L);
        RWLock lock = this.createRWLock(ragManager, resource);
        Transaction tx1 = (Transaction)Mockito.mock(Transaction.class);
        lock.mark();
        lock.acquireReadLock(LockTracer.NONE, (Object)tx1);
        lock.mark();
        Assert.assertEquals((Object)1, (Object)lock.getTxLockElementCount());
        lock.releaseReadLock((Object)tx1);
        Assert.assertEquals((Object)0, (Object)lock.getTxLockElementCount());
    }

    @Test(timeout=10000L)
    public void testWaitingWriterLock() throws InterruptedException {
        RagManager ragManager = new RagManager();
        LockResource resource = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        RWLock lock = this.createRWLock(ragManager, resource);
        LockTransaction lockTransaction = new LockTransaction();
        LockTransaction anotherTransaction = new LockTransaction();
        lock.mark();
        lock.acquireReadLock(LockTracer.NONE, (Object)lockTransaction);
        lock.mark();
        lock.acquireReadLock(LockTracer.NONE, (Object)anotherTransaction);
        CountDownLatch writerCompletedLatch = new CountDownLatch(1);
        Runnable writer = this.createWriter(lock, lockTransaction, writerCompletedLatch);
        executor.execute(writer);
        this.waitWaitingThreads(lock, 1);
        Assert.assertEquals((String)"No writers for now.", (long)0L, (long)lock.getWriteCount());
        Assert.assertEquals((long)2L, (long)lock.getReadCount());
        lock.releaseReadLock((Object)lockTransaction);
        lock.releaseReadLock((Object)anotherTransaction);
        writerCompletedLatch.await();
        Assert.assertEquals((long)1L, (long)lock.getWriteCount());
        Assert.assertEquals((long)0L, (long)lock.getReadCount());
        lock.releaseWriteLock((Object)lockTransaction);
        Assert.assertEquals((String)"Lock should not have any writers left.", (long)0L, (long)lock.getWriteCount());
        Assert.assertEquals((String)"No waiting threads left.", (long)0L, (long)lock.getWaitingThreadsCount());
        Assert.assertEquals((String)"No lock elements left.", (Object)0, (Object)lock.getTxLockElementCount());
    }

    @Test(timeout=10000L)
    public void testWaitingReaderLock() throws InterruptedException {
        RagManager ragManager = new RagManager();
        LockResource resource = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        RWLock lock = this.createRWLock(ragManager, resource);
        LockTransaction transaction = new LockTransaction();
        LockTransaction readerTransaction = new LockTransaction();
        CountDownLatch readerCompletedLatch = new CountDownLatch(1);
        lock.mark();
        lock.acquireWriteLock(LockTracer.NONE, (Object)transaction);
        Runnable reader = this.createReader(lock, readerTransaction, readerCompletedLatch);
        executor.execute(reader);
        this.waitWaitingThreads(lock, 1);
        Assert.assertEquals((long)1L, (long)lock.getWriteCount());
        Assert.assertEquals((String)"No readers for now", (long)0L, (long)lock.getReadCount());
        lock.releaseWriteLock((Object)transaction);
        readerCompletedLatch.await();
        Assert.assertEquals((long)0L, (long)lock.getWriteCount());
        Assert.assertEquals((long)1L, (long)lock.getReadCount());
        lock.releaseReadLock((Object)readerTransaction);
        Assert.assertEquals((String)"Lock should not have any readers left.", (long)0L, (long)lock.getReadCount());
        Assert.assertEquals((String)"No waiting threads left.", (long)0L, (long)lock.getWaitingThreadsCount());
        Assert.assertEquals((String)"No lock elements left.", (Object)0, (Object)lock.getTxLockElementCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testThreadRemovedFromWaitingListOnDeadlock() throws InterruptedException {
        RagManager ragManager = (RagManager)Mockito.mock(RagManager.class);
        LockResource resource = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        RWLock lock = this.createRWLock(ragManager, resource);
        LockTransaction lockTransaction = new LockTransaction();
        LockTransaction anotherTransaction = new LockTransaction();
        CountDownLatch exceptionLatch = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(1);
        ((RagManager)Mockito.doNothing().doAnswer(invocation -> {
            exceptionLatch.countDown();
            throw new DeadlockDetectedException("Deadlock");
        }).when((Object)ragManager)).checkWaitOn((Object)lock, (Object)lockTransaction);
        lock.mark();
        lock.mark();
        lock.acquireReadLock(LockTracer.NONE, (Object)lockTransaction);
        lock.acquireReadLock(LockTracer.NONE, (Object)anotherTransaction);
        Runnable writer = () -> {
            try {
                lock.mark();
                lock.acquireWriteLock(LockTracer.NONE, (Object)lockTransaction);
            }
            catch (DeadlockDetectedException deadlockDetectedException) {
                // empty catch block
            }
            completionLatch.countDown();
        };
        executor.execute(writer);
        this.waitWaitingThreads(lock, 1);
        do {
            RWLock rWLock = lock;
            synchronized (rWLock) {
                lock.notifyAll();
            }
        } while (exceptionLatch.getCount() == 1L);
        completionLatch.await();
        Assert.assertEquals((String)"In case of deadlock caused by spurious wake up thread should be removed from waiting list", (long)0L, (long)lock.getWaitingThreadsCount());
    }

    @Test
    public void testLockCounters() throws InterruptedException {
        RagManager ragManager = new RagManager();
        LockResource resource = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        RWLock lock = this.createRWLock(ragManager, resource);
        LockTransaction lockTransaction = new LockTransaction();
        LockTransaction anotherTransaction = new LockTransaction();
        LockTransaction writeTransaction = new LockTransaction();
        CountDownLatch writerCompletedLatch = new CountDownLatch(1);
        lock.mark();
        lock.acquireReadLock(LockTracer.NONE, (Object)lockTransaction);
        lock.mark();
        lock.acquireReadLock(LockTracer.NONE, (Object)anotherTransaction);
        Assert.assertEquals((long)2L, (long)lock.getReadCount());
        Assert.assertEquals((long)0L, (long)lock.getWriteCount());
        Assert.assertEquals((Object)2, (Object)lock.getTxLockElementCount());
        Runnable writer = this.createWriter(lock, writeTransaction, writerCompletedLatch);
        executor.submit(writer);
        this.waitWaitingThreads(lock, 1);
        Assert.assertEquals((long)2L, (long)lock.getReadCount());
        Assert.assertEquals((long)0L, (long)lock.getWriteCount());
        Assert.assertEquals((Object)3, (Object)lock.getTxLockElementCount());
        Assert.assertEquals((long)1L, (long)lock.getWaitingThreadsCount());
        lock.releaseReadLock((Object)lockTransaction);
        lock.releaseReadLock((Object)anotherTransaction);
        writerCompletedLatch.await();
        Assert.assertEquals((long)0L, (long)lock.getReadCount());
        Assert.assertEquals((long)1L, (long)lock.getWriteCount());
        Assert.assertEquals((Object)1, (Object)lock.getTxLockElementCount());
        Assert.assertEquals((long)0L, (long)lock.getWaitingThreadsCount());
        lock.releaseWriteLock((Object)writeTransaction);
        Assert.assertEquals((Object)0, (Object)lock.getTxLockElementCount());
        Assert.assertEquals((long)0L, (long)lock.getWaitingThreadsCount());
        Assert.assertEquals((long)0L, (long)lock.getReadCount());
        Assert.assertEquals((long)0L, (long)lock.getWriteCount());
    }

    @Test(timeout=10000L)
    public void testDeadlockDetection() throws InterruptedException {
        RagManager ragManager = new RagManager();
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockResource node2 = new LockResource((ResourceType)ResourceTypes.NODE, 2L);
        LockResource node3 = new LockResource((ResourceType)ResourceTypes.NODE, 3L);
        RWLock lockNode1 = this.createRWLock(ragManager, node1);
        RWLock lockNode2 = this.createRWLock(ragManager, node2);
        RWLock lockNode3 = this.createRWLock(ragManager, node3);
        LockTransaction client1Transaction = new LockTransaction();
        LockTransaction client2Transaction = new LockTransaction();
        LockTransaction client3Transaction = new LockTransaction();
        CountDownLatch deadLockDetector = new CountDownLatch(1);
        lockNode1.mark();
        lockNode1.acquireWriteLock(LockTracer.NONE, (Object)client1Transaction);
        lockNode2.mark();
        lockNode2.acquireWriteLock(LockTracer.NONE, (Object)client2Transaction);
        lockNode3.mark();
        lockNode3.acquireWriteLock(LockTracer.NONE, (Object)client3Transaction);
        Runnable readerLockNode2 = this.createReaderForDeadlock(lockNode3, client1Transaction, deadLockDetector);
        Runnable readerLockNode3 = this.createReaderForDeadlock(lockNode1, client2Transaction, deadLockDetector);
        Runnable readerLockNode1 = this.createReaderForDeadlock(lockNode2, client3Transaction, deadLockDetector);
        executor.execute(readerLockNode2);
        executor.execute(readerLockNode3);
        executor.execute(readerLockNode1);
        Assert.assertTrue((String)"Deadlock was detected as expected.", (boolean)deadLockDetector.await(10000L, TimeUnit.MILLISECONDS));
        lockNode3.releaseWriteLock((Object)client3Transaction);
        lockNode2.releaseWriteLock((Object)client2Transaction);
        lockNode1.releaseWriteLock((Object)client1Transaction);
    }

    @Test(timeout=10000L)
    public void testLockRequestsTermination() throws InterruptedException {
        RagManager ragManager = new RagManager();
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        RWLock lock = this.createRWLock(ragManager, node1);
        LockTransaction mainTransaction = new LockTransaction();
        LockTransaction writerTransaction = new LockTransaction();
        CountDownLatch writerCompletedLatch = new CountDownLatch(1);
        Runnable conflictingWriter = this.createFailedWriter(lock, writerTransaction, writerCompletedLatch);
        LockTransaction readerTransaction = new LockTransaction();
        CountDownLatch readerCompletedLatch = new CountDownLatch(1);
        Runnable reader = this.createFailedReader(lock, readerTransaction, readerCompletedLatch);
        lock.mark();
        Assert.assertTrue((boolean)lock.acquireWriteLock(LockTracer.NONE, (Object)mainTransaction));
        executor.submit(reader);
        executor.submit(conflictingWriter);
        this.waitWaitingThreads(lock, 2);
        Assert.assertEquals((Object)3, (Object)lock.getTxLockElementCount());
        lock.terminateLockRequestsForLockTransaction((Object)readerTransaction);
        lock.terminateLockRequestsForLockTransaction((Object)writerTransaction);
        readerCompletedLatch.await();
        writerCompletedLatch.await();
        Assert.assertEquals((long)0L, (long)lock.getWaitingThreadsCount());
        Assert.assertEquals((long)0L, (long)lock.getReadCount());
        Assert.assertEquals((long)1L, (long)lock.getWriteCount());
        Assert.assertEquals((Object)1, (Object)lock.getTxLockElementCount());
    }

    private Runnable createReader(RWLock lock, LockTransaction transaction, CountDownLatch latch) {
        return () -> {
            lock.mark();
            lock.acquireReadLock(LockTracer.NONE, (Object)transaction);
            latch.countDown();
        };
    }

    private Runnable createFailedReader(RWLock lock, LockTransaction transaction, CountDownLatch latch) {
        return () -> {
            lock.mark();
            Assert.assertFalse((boolean)lock.acquireReadLock(LockTracer.NONE, (Object)transaction));
            latch.countDown();
        };
    }

    private Runnable createWriter(RWLock lock, LockTransaction transaction, CountDownLatch latch) {
        return () -> {
            lock.mark();
            lock.acquireWriteLock(LockTracer.NONE, (Object)transaction);
            latch.countDown();
        };
    }

    private Runnable createFailedWriter(RWLock lock, LockTransaction transaction, CountDownLatch latch) {
        return () -> {
            lock.mark();
            Assert.assertFalse((boolean)lock.acquireWriteLock(LockTracer.NONE, (Object)transaction));
            latch.countDown();
        };
    }

    private Runnable createReaderForDeadlock(RWLock node, LockTransaction transaction, CountDownLatch latch) {
        return () -> {
            try {
                node.mark();
                node.acquireReadLock(LockTracer.NONE, (Object)transaction);
            }
            catch (DeadlockDetectedException e) {
                latch.countDown();
            }
        };
    }

    private RWLock createRWLock(RagManager ragManager, LockResource resource) {
        return new RWLock(resource, ragManager, Clocks.systemClock(), 0L);
    }

    private void waitWaitingThreads(RWLock lock, int expectedThreads) throws InterruptedException {
        while (lock.getWaitingThreadsCount() != expectedThreads) {
            Thread.sleep(20L);
        }
    }
}

