/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexLimitation;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.kernel.impl.newapi.UnionIndexCapability;
import org.neo4j.values.storable.ValueCategory;

public class UnionIndexCapabilityTest {
    private static final IndexOrder[] ORDER_CAPABILITIES_ALL = new IndexOrder[]{IndexOrder.ASCENDING, IndexOrder.DESCENDING};
    private static final IndexOrder[] ORDER_CAPABILITIES_ONLY_ASC = new IndexOrder[]{IndexOrder.ASCENDING};
    private static final IndexOrder[] ORDER_CAPABILITIES_ONLY_DES = new IndexOrder[]{IndexOrder.DESCENDING};
    private static final IndexOrder[] ORDER_CAPABILITIES_NONE = new IndexOrder[0];

    @Test
    public void shouldCreateUnionOfOrderCapabilities() {
        UnionIndexCapability union = this.unionOfOrderCapabilities(ORDER_CAPABILITIES_NONE, ORDER_CAPABILITIES_ONLY_ASC);
        this.assertOrderCapability(union, ORDER_CAPABILITIES_ONLY_ASC);
        union = this.unionOfOrderCapabilities(ORDER_CAPABILITIES_NONE, ORDER_CAPABILITIES_ALL);
        this.assertOrderCapability(union, ORDER_CAPABILITIES_ALL);
        union = this.unionOfOrderCapabilities(ORDER_CAPABILITIES_ONLY_ASC, ORDER_CAPABILITIES_ONLY_DES);
        this.assertOrderCapability(union, ORDER_CAPABILITIES_ALL);
        union = this.unionOfOrderCapabilities(ORDER_CAPABILITIES_ONLY_ASC, ORDER_CAPABILITIES_ALL);
        this.assertOrderCapability(union, ORDER_CAPABILITIES_ALL);
        union = this.unionOfOrderCapabilities(ORDER_CAPABILITIES_ONLY_ASC, ORDER_CAPABILITIES_ONLY_ASC);
        this.assertOrderCapability(union, ORDER_CAPABILITIES_ONLY_ASC);
    }

    @Test
    public void shouldCreateUnionOfValueCapability() {
        UnionIndexCapability union = this.unionOfValueCapabilities(IndexValueCapability.NO, IndexValueCapability.NO);
        this.assertValueCapability(union, IndexValueCapability.NO);
        union = this.unionOfValueCapabilities(IndexValueCapability.NO, IndexValueCapability.PARTIAL);
        this.assertValueCapability(union, IndexValueCapability.PARTIAL);
        union = this.unionOfValueCapabilities(IndexValueCapability.NO, IndexValueCapability.YES);
        this.assertValueCapability(union, IndexValueCapability.YES);
        union = this.unionOfValueCapabilities(IndexValueCapability.PARTIAL, IndexValueCapability.PARTIAL);
        this.assertValueCapability(union, IndexValueCapability.PARTIAL);
        union = this.unionOfValueCapabilities(IndexValueCapability.PARTIAL, IndexValueCapability.YES);
        this.assertValueCapability(union, IndexValueCapability.YES);
        union = this.unionOfValueCapabilities(IndexValueCapability.YES, IndexValueCapability.YES);
        this.assertValueCapability(union, IndexValueCapability.YES);
    }

    @Test
    public void shouldCreateUnionOfIndexLimitations() {
        UnionIndexCapability union = this.unionOfIndexLimitations(IndexCapability.LIMITIATION_NONE, IndexCapability.LIMITIATION_NONE);
        Assert.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Object[])union.limitations()));
        union = this.unionOfIndexLimitations(IndexCapability.LIMITIATION_NONE, (IndexLimitation[])ArrayUtil.array((Object[])new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS}), (Object)Iterators.asSet((Object[])union.limitations()));
        union = this.unionOfIndexLimitations((IndexLimitation[])ArrayUtil.array((Object[])new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS}), (IndexLimitation[])ArrayUtil.array((Object[])new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS}), (Object)Iterators.asSet((Object[])union.limitations()));
    }

    private UnionIndexCapability unionOfIndexLimitations(IndexLimitation[] ... limitiations) {
        IndexCapability[] capabilities = new IndexCapability[limitiations.length];
        for (int i = 0; i < limitiations.length; ++i) {
            capabilities[i] = this.capabilityWithIndexLimitations(limitiations[i]);
        }
        return new UnionIndexCapability(capabilities);
    }

    private IndexCapability capabilityWithIndexLimitations(IndexLimitation[] limitations) {
        IndexCapability mock = this.mockedIndexCapability();
        Mockito.when((Object)mock.limitations()).thenReturn((Object)limitations);
        return mock;
    }

    private UnionIndexCapability unionOfValueCapabilities(IndexValueCapability ... valueCapabilities) {
        IndexCapability[] capabilities = new IndexCapability[valueCapabilities.length];
        for (int i = 0; i < valueCapabilities.length; ++i) {
            capabilities[i] = this.capabilityWithValue(valueCapabilities[i]);
        }
        return new UnionIndexCapability(capabilities);
    }

    private UnionIndexCapability unionOfOrderCapabilities(IndexOrder[] ... indexOrders) {
        IndexCapability[] capabilities = new IndexCapability[indexOrders.length];
        for (int i = 0; i < indexOrders.length; ++i) {
            capabilities[i] = this.capabilityWithOrder(indexOrders[i]);
        }
        return new UnionIndexCapability(capabilities);
    }

    private IndexCapability capabilityWithValue(IndexValueCapability valueCapability) {
        IndexCapability mock = this.mockedIndexCapability();
        Mockito.when((Object)mock.valueCapability((ValueCategory[])ArgumentMatchers.any())).thenReturn((Object)valueCapability);
        return mock;
    }

    private IndexCapability mockedIndexCapability() {
        IndexCapability mock = (IndexCapability)Mockito.mock(IndexCapability.class);
        Mockito.when((Object)mock.limitations()).thenReturn((Object)IndexCapability.LIMITIATION_NONE);
        return mock;
    }

    private IndexCapability capabilityWithOrder(IndexOrder[] indexOrder) {
        IndexCapability mock = this.mockedIndexCapability();
        Mockito.when((Object)mock.orderCapability((ValueCategory[])ArgumentMatchers.any())).thenReturn((Object)indexOrder);
        return mock;
    }

    private void assertValueCapability(UnionIndexCapability union, IndexValueCapability expectedValueCapability) {
        IndexValueCapability actual = union.valueCapability(new ValueCategory[]{this.someValueCategory()});
        Assert.assertEquals((Object)expectedValueCapability, (Object)actual);
    }

    private void assertOrderCapability(UnionIndexCapability union, IndexOrder ... expected) {
        Object[] actual = union.orderCapability(new ValueCategory[]{this.someValueCategory()});
        Assert.assertTrue((String)"Actual contains all expected", (boolean)ArrayUtil.containsAll((Object[])expected, (Object[])actual));
        Assert.assertTrue((String)"Actual contains nothing else than expected", (boolean)ArrayUtil.containsAll((Object[])actual, (Object[])expected));
    }

    private ValueCategory someValueCategory() {
        return ValueCategory.TEXT;
    }
}

