/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.PrimitiveLongDiffSets;
import org.neo4j.storageengine.api.txstate.PrimitiveLongDiffSetsVisitor;

public class PrimitiveLongDiffSetsTest {
    @Test
    public void newDiffSetIsEmpty() {
        Assert.assertTrue((boolean)PrimitiveLongDiffSetsTest.createDiffSet().isEmpty());
    }

    @Test
    public void addElementsToDiffSets() {
        PrimitiveLongDiffSets diffSets = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSets.add(1L);
        diffSets.add(2L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)diffSets.getAdded()));
        Assert.assertTrue((boolean)diffSets.getRemoved().isEmpty());
        Assert.assertFalse((boolean)diffSets.isEmpty());
    }

    @Test
    public void removeElementsInDiffSets() {
        PrimitiveLongDiffSets diffSets = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSets.remove(1L);
        diffSets.remove(2L);
        Assert.assertFalse((boolean)diffSets.isEmpty());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)diffSets.getRemoved()));
    }

    @Test
    public void removeAndAddElementsToDiffSets() {
        PrimitiveLongDiffSets diffSets = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSets.remove(1L);
        diffSets.remove(2L);
        diffSets.add(1L);
        diffSets.add(2L);
        diffSets.add(3L);
        diffSets.remove(4L);
        Assert.assertFalse((boolean)diffSets.isEmpty());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{4L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)diffSets.getRemoved()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{3L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)diffSets.getAdded()));
    }

    @Test
    public void checkIsElementsAddedOrRemoved() {
        PrimitiveLongDiffSets diffSet = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSet.add(1L);
        Assert.assertTrue((boolean)diffSet.isAdded(1L));
        Assert.assertFalse((boolean)diffSet.isRemoved(1L));
        diffSet.remove(2L);
        Assert.assertFalse((boolean)diffSet.isAdded(2L));
        Assert.assertTrue((boolean)diffSet.isRemoved(2L));
        Assert.assertFalse((boolean)diffSet.isAdded(3L));
        Assert.assertFalse((boolean)diffSet.isRemoved(3L));
    }

    @Test
    public void addAllElements() {
        PrimitiveLongDiffSets diffSet = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSet.addAll(PrimitiveLongCollections.iterator((long[])new long[]{7L, 8L}));
        diffSet.addAll(PrimitiveLongCollections.iterator((long[])new long[]{9L, 10L}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{7L, 8L, 9L, 10L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)diffSet.getAdded()));
    }

    @Test
    public void removeAllElements() {
        PrimitiveLongDiffSets diffSet = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSet.removeAll(PrimitiveLongCollections.iterator((long[])new long[]{7L, 8L}));
        diffSet.removeAll(PrimitiveLongCollections.iterator((long[])new long[]{9L, 10L}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{7L, 8L, 9L, 10L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)diffSet.getRemoved()));
    }

    @Test
    public void addedAndRemovedElementsDelta() {
        PrimitiveLongDiffSets diffSet = PrimitiveLongDiffSetsTest.createDiffSet();
        Assert.assertEquals((long)0L, (long)diffSet.delta());
        diffSet.addAll(PrimitiveLongCollections.iterator((long[])new long[]{7L, 8L}));
        diffSet.addAll(PrimitiveLongCollections.iterator((long[])new long[]{9L, 10L}));
        Assert.assertEquals((long)4L, (long)diffSet.delta());
        diffSet.removeAll(PrimitiveLongCollections.iterator((long[])new long[]{8L, 9L}));
        Assert.assertEquals((long)2L, (long)diffSet.delta());
    }

    @Test
    public void augmentDiffSetWithExternalElements() {
        PrimitiveLongDiffSets diffSet = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSet.addAll(PrimitiveLongCollections.iterator((long[])new long[]{9L, 10L, 11L}));
        diffSet.removeAll(PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L}));
        PrimitiveLongIterator augmentedIterator = diffSet.augment(PrimitiveLongCollections.iterator((long[])new long[]{5L, 6L}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{5L, 6L, 9L, 10L, 11L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)augmentedIterator));
    }

    @Test
    public void visitAddedAndRemovedElements() {
        PrimitiveLongDiffSets diffSet = PrimitiveLongDiffSetsTest.createDiffSet();
        diffSet.addAll(PrimitiveLongCollections.iterator((long[])new long[]{9L, 10L, 11L}));
        diffSet.removeAll(PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L}));
        AggregatedPrimitiveLongDiffSetsVisitor visitor = new AggregatedPrimitiveLongDiffSetsVisitor();
        diffSet.visit((PrimitiveLongDiffSetsVisitor)visitor);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{9L, 10L, 11L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)visitor.getAddedElements()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongSet)visitor.getRemovedElements()));
    }

    @Test
    public void useCollectionsFactory() {
        PrimitiveLongSet set1 = Primitive.longSet();
        PrimitiveLongSet set2 = Primitive.longSet();
        CollectionsFactory collectionsFactory = (CollectionsFactory)Mockito.mock(CollectionsFactory.class);
        ((CollectionsFactory)Mockito.doReturn((Object)set1, (Object[])new Object[]{set2}).when((Object)collectionsFactory)).newLongSet();
        PrimitiveLongDiffSets diffSets = new PrimitiveLongDiffSets(PrimitiveLongCollections.emptySet(), PrimitiveLongCollections.emptySet(), collectionsFactory);
        diffSets.add(1L);
        diffSets.remove(2L);
        Assert.assertSame((Object)set1, (Object)diffSets.getAdded());
        Assert.assertSame((Object)set2, (Object)diffSets.getRemoved());
        ((CollectionsFactory)Mockito.verify((Object)collectionsFactory, (VerificationMode)Mockito.times((int)2))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collectionsFactory});
    }

    private static PrimitiveLongDiffSets createDiffSet() {
        return new PrimitiveLongDiffSets(PrimitiveLongCollections.emptySet(), PrimitiveLongCollections.emptySet(), OnHeapCollectionsFactory.INSTANCE);
    }

    private static class AggregatedPrimitiveLongDiffSetsVisitor
    implements PrimitiveLongDiffSetsVisitor {
        private final PrimitiveLongSet addedElements = Primitive.longSet();
        private final PrimitiveLongSet removedElements = Primitive.longSet();

        private AggregatedPrimitiveLongDiffSetsVisitor() {
        }

        public void visitAdded(long element) {
            this.addedElements.add(element);
        }

        public void visitRemoved(long element) {
            this.removedElements.add(element);
        }

        PrimitiveLongSet getAddedElements() {
            return this.addedElements;
        }

        PrimitiveLongSet getRemovedElements() {
            return this.removedElements;
        }
    }
}

