/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class InputCacheTest {
    private static final String[] TOKENS = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven"};
    private static final int countPerThread = 10000;
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final TestDirectory dir = TestDirectory.testDirectory();
    private final RandomRule randomRule = new RandomRule().withSeedForAllTests(1515752471383L);
    private final int threads = Runtime.getRuntime().availableProcessors();
    private final ExecutorService executor = Executors.newFixedThreadPool(this.threads);
    private final List<Future<?>> futures = new ArrayList();
    private final int totalCount = this.threads * 10000;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.dir).around((TestRule)this.randomRule).around((TestRule)this.fileSystemRule);

    @Test
    public void shouldCacheAndRetrieveNodes() throws Exception {
        try (InputCache cache = new InputCache(this.fileSystemRule.get(), this.dir.directory(), Standard.LATEST_RECORD_FORMATS, (int)ByteUnit.kibiBytes((long)8L));){
            try (InputCacher cacher = cache.cacheNodes();){
                this.writeEntities(cacher, this::randomNode);
            }
            var4_6 = null;
            try (InputIterator reader = cache.nodes().iterator();){
                List<InputEntity> allReadEntities = this.readEntities(reader);
                Assert.assertEquals((long)this.totalCount, (long)allReadEntities.size());
                this.executor.shutdown();
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
        this.assertNoFilesLeftBehind();
    }

    @Test
    public void shouldCacheAndRetrieveRelationships() throws Exception {
        try (InputCache cache = new InputCache(this.fileSystemRule.get(), this.dir.directory(), Standard.LATEST_RECORD_FORMATS, 200);){
            try (InputCacher cacher = cache.cacheRelationships();){
                this.writeEntities(cacher, this::randomRelationship);
            }
            var4_6 = null;
            try (InputIterator reader = cache.relationships().iterator();){
                List<InputEntity> allReadEntities = this.readEntities(reader);
                Assert.assertEquals((long)this.totalCount, (long)allReadEntities.size());
                this.executor.shutdown();
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
        this.assertNoFilesLeftBehind();
    }

    private List<InputEntity> readEntities(InputIterator reader) throws Exception {
        for (int i = 0; i < this.threads; ++i) {
            this.submit(() -> {
                ArrayList<InputEntity> entities = new ArrayList<InputEntity>();
                try (InputChunk chunk = reader.newChunk();){
                    while (reader.next(chunk)) {
                        InputEntity entity = new InputEntity();
                        while (chunk.next((InputEntityVisitor)entity)) {
                            entities.add(entity);
                            entity = new InputEntity();
                        }
                    }
                }
                return entities;
            });
        }
        ArrayList<InputEntity> allReadEntities = new ArrayList<InputEntity>();
        this.results(allReadEntities::addAll);
        return allReadEntities;
    }

    private void writeEntities(InputCacher cacher, BiConsumer<Randoms, InputEntityVisitor> generator) throws Exception {
        for (int i = 0; i < this.threads; ++i) {
            Randoms localRandom = new Randoms(new Random(this.randomRule.seed() + (long)i), Randoms.DEFAULT);
            this.submit(() -> {
                InputEntity actual = new InputEntity();
                try (InputEntityVisitor local = cacher.wrap((InputEntityVisitor)actual);){
                    for (int j = 0; j < 10000; ++j) {
                        generator.accept(localRandom, local);
                    }
                }
                return null;
            });
        }
        this.results(ignore -> {});
    }

    private void assertNoFilesLeftBehind() {
        Assert.assertEquals((long)0L, (long)((DefaultFileSystemAbstraction)this.fileSystemRule.get()).listFiles(this.dir.directory()).length);
    }

    private void randomRelationship(Randoms random, InputEntityVisitor relationship) {
        if (random.random().nextFloat() < 0.1f) {
            relationship.type(Math.abs(random.random().nextInt(20000)));
            relationship.propertyId(Math.abs(random.random().nextLong()));
        } else {
            relationship.type(this.randomType(random));
            this.randomProperties(relationship, random);
        }
        relationship.startId((Object)this.randomId(random), this.randomGroup(random));
        relationship.endId((Object)this.randomId(random), this.randomGroup(random));
        try {
            relationship.endOfEntity();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void randomNode(Randoms random, InputEntityVisitor node) {
        if (random.random().nextFloat() < 0.1f) {
            node.id(this.randomId(random));
            node.propertyId(this.randomId(random));
            node.labelField(this.randomId(random));
        } else {
            node.id((Object)this.randomId(random), this.randomGroup(random));
            this.randomProperties(node, random);
            node.labels(this.randomLabels(random));
        }
        try {
            node.endOfEntity();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void randomProperties(InputEntityVisitor entity, Randoms random) {
        int length = random.random().nextInt(10);
        for (int i = 0; i < length; ++i) {
            Object value = random.propertyValue();
            if (random.random().nextFloat() < 0.2f) {
                entity.property(random.intBetween(0, 10), value);
                continue;
            }
            entity.property((String)random.among((Object[])TOKENS), value);
        }
    }

    private String randomType(Randoms random) {
        return (String)random.among((Object[])TOKENS);
    }

    private Group randomGroup(Randoms random) {
        return new Group.Adapter(random.nextInt(100), random.string());
    }

    private String[] randomLabels(Randoms random) {
        return (String[])random.selection((Object[])TOKENS, 1, 5, false);
    }

    private long randomId(Randoms random) {
        return Math.abs(random.random().nextLong());
    }

    private void submit(Callable<?> toRun) {
        this.futures.add(this.executor.submit(toRun));
    }

    private <T> void results(Consumer<T> consumer) throws Exception {
        for (Future<?> future : this.futures) {
            consumer.accept(future.get());
        }
        this.futures.clear();
    }
}

