/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitable;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.api.store.DefaultIndexReference;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDbStructureGuide
implements Visitable<DbStructureVisitor> {
    private static RelationshipType WILDCARD_REL_TYPE = () -> "";
    private final GraphDatabaseService db;
    private final ThreadToStatementContextBridge bridge;

    public GraphDbStructureGuide(GraphDatabaseService graph) {
        this.db = graph;
        DependencyResolver dependencies = ((GraphDatabaseAPI)graph).getDependencyResolver();
        this.bridge = (ThreadToStatementContextBridge)dependencies.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public void accept(DbStructureVisitor visitor) {
        try (Transaction tx = this.db.beginTx();){
            this.showStructure(this.bridge.getKernelTransactionBoundToThisThread(true), visitor);
            tx.success();
        }
    }

    private void showStructure(KernelTransaction ktx, DbStructureVisitor visitor) {
        try {
            this.showTokens(visitor, ktx);
            this.showSchema(visitor, ktx);
            this.showStatistics(visitor, ktx);
        }
        catch (KernelException e) {
            throw new IllegalStateException("Kernel exception when traversing database schema structure and statistics. This is not expected to happen.", e);
        }
    }

    private void showTokens(DbStructureVisitor visitor, KernelTransaction ktx) {
        this.showLabels(ktx, visitor);
        this.showPropertyKeys(ktx, visitor);
        this.showRelTypes(ktx, visitor);
    }

    private void showLabels(KernelTransaction ktx, DbStructureVisitor visitor) {
        for (Label label : this.db.getAllLabels()) {
            int labelId = ktx.tokenRead().nodeLabel(label.name());
            visitor.visitLabel(labelId, label.name());
        }
    }

    private void showPropertyKeys(KernelTransaction ktx, DbStructureVisitor visitor) {
        for (String propertyKeyName : this.db.getAllPropertyKeys()) {
            int propertyKeyId = ktx.tokenRead().propertyKey(propertyKeyName);
            visitor.visitPropertyKey(propertyKeyId, propertyKeyName);
        }
    }

    private void showRelTypes(KernelTransaction ktx, DbStructureVisitor visitor) {
        for (RelationshipType relType : this.db.getAllRelationshipTypes()) {
            int relTypeId = ktx.tokenRead().relationshipType(relType.name());
            visitor.visitRelationshipType(relTypeId, relType.name());
        }
    }

    private void showSchema(DbStructureVisitor visitor, KernelTransaction ktx) throws IndexNotFoundKernelException {
        SilentTokenNameLookup nameLookup = new SilentTokenNameLookup(ktx.tokenRead());
        this.showIndices(visitor, ktx, nameLookup);
        this.showUniqueConstraints(visitor, ktx, nameLookup);
    }

    private void showIndices(DbStructureVisitor visitor, KernelTransaction ktx, TokenNameLookup nameLookup) throws IndexNotFoundKernelException {
        SchemaRead schemaRead = ktx.schemaRead();
        for (IndexReference reference : Iterators.loop((Iterator)IndexReference.sortByType((Iterator)schemaRead.indexesGetAll()))) {
            String userDescription = SchemaDescriptorFactory.forLabel(reference.label(), reference.properties()).userDescription(nameLookup);
            double uniqueValuesPercentage = schemaRead.indexUniqueValuesSelectivity(reference);
            long size = schemaRead.indexSize(reference);
            visitor.visitIndex(DefaultIndexReference.toDescriptor(reference), userDescription, uniqueValuesPercentage, size);
        }
    }

    private void showUniqueConstraints(DbStructureVisitor visitor, KernelTransaction ktx, TokenNameLookup nameLookup) {
        Iterator constraints = ktx.schemaRead().constraintsGetAll();
        while (constraints.hasNext()) {
            org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor existenceConstraint;
            ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.next();
            String userDescription = constraint.prettyPrint(nameLookup);
            if (constraint instanceof UniquenessConstraintDescriptor) {
                visitor.visitUniqueConstraint((UniquenessConstraintDescriptor)constraint, userDescription);
                continue;
            }
            if (constraint instanceof NodeExistenceConstraintDescriptor) {
                existenceConstraint = (NodeExistenceConstraintDescriptor)constraint;
                visitor.visitNodePropertyExistenceConstraint((NodeExistenceConstraintDescriptor)existenceConstraint, userDescription);
                continue;
            }
            if (constraint instanceof RelExistenceConstraintDescriptor) {
                existenceConstraint = (RelExistenceConstraintDescriptor)constraint;
                visitor.visitRelationshipPropertyExistenceConstraint((RelExistenceConstraintDescriptor)existenceConstraint, userDescription);
                continue;
            }
            if (constraint instanceof NodeKeyConstraintDescriptor) {
                NodeKeyConstraintDescriptor nodeKeyConstraint = (NodeKeyConstraintDescriptor)constraint;
                visitor.visitNodeKeyConstraint(nodeKeyConstraint, userDescription);
                continue;
            }
            throw new IllegalArgumentException("Unknown constraint type: " + constraint.getClass() + ", constraint: " + constraint);
        }
    }

    private void showStatistics(DbStructureVisitor visitor, KernelTransaction ktx) {
        this.showNodeCounts(ktx, visitor);
        this.showRelCounts(ktx, visitor);
    }

    private void showNodeCounts(KernelTransaction ktx, DbStructureVisitor visitor) {
        Read read = ktx.dataRead();
        visitor.visitAllNodesCount(read.countsForNode(-1));
        for (Label label : this.db.getAllLabels()) {
            int labelId = ktx.tokenRead().nodeLabel(label.name());
            visitor.visitNodeCount(labelId, label.name(), read.countsForNode(labelId));
        }
    }

    private void showRelCounts(KernelTransaction ktx, DbStructureVisitor visitor) {
        this.noSide(ktx, visitor, WILDCARD_REL_TYPE, -1);
        TokenRead tokenRead = ktx.tokenRead();
        for (Label label : this.db.getAllLabels()) {
            int labelId = tokenRead.nodeLabel(label.name());
            this.leftSide(ktx, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
            this.rightSide(ktx, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
        }
        for (RelationshipType relType : this.db.getAllRelationshipTypes()) {
            int relTypeId = tokenRead.relationshipType(relType.name());
            this.noSide(ktx, visitor, relType, relTypeId);
            for (Label label : this.db.getAllLabels()) {
                int labelId = tokenRead.nodeLabel(label.name());
                this.leftSide(ktx, visitor, label, labelId, relType, relTypeId);
                this.rightSide(ktx, visitor, label, labelId, relType, relTypeId);
            }
        }
    }

    private void noSide(KernelTransaction ktx, DbStructureVisitor visitor, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->() RETURN count(*)", this.colon(relType.name()));
        long amount = ktx.dataRead().countsForRelationship(-1, relTypeId, -1);
        visitor.visitRelCount(-1, relTypeId, -1, userDescription, amount);
    }

    private void leftSide(KernelTransaction ktx, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH (%s)-[%s]->() RETURN count(*)", this.colon(label.name()), this.colon(relType.name()));
        long amount = ktx.dataRead().countsForRelationship(labelId, relTypeId, -1);
        visitor.visitRelCount(labelId, relTypeId, -1, userDescription, amount);
    }

    private void rightSide(KernelTransaction ktx, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->(%s) RETURN count(*)", this.colon(relType.name()), this.colon(label.name()));
        long amount = ktx.dataRead().countsForRelationship(-1, relTypeId, labelId);
        visitor.visitRelCount(-1, relTypeId, labelId, userDescription, amount);
    }

    private String colon(String name) {
        return name.length() == 0 ? name : ":" + name;
    }
}

