/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;

public class TestArgs {
    @Test
    public void testInterleavedParametersWithValuesAndNot() {
        String[] line = new String[]{"-host", "machine.foo.com", "-port", "1234", "-v", "-name", "othershell"};
        Args args = Args.parse((String[])line);
        Assert.assertEquals((Object)"machine.foo.com", (Object)args.get("host", null));
        Assert.assertEquals((Object)"1234", (Object)args.get("port", null));
        Assert.assertEquals((long)1234L, (long)args.getNumber("port", null).intValue());
        Assert.assertEquals((Object)"othershell", (Object)args.get("name", null));
        Assert.assertTrue((boolean)args.has("v"));
        Assert.assertTrue((boolean)args.orphans().isEmpty());
    }

    @Test
    public void testInterleavedEqualsArgsAndSplitKeyValue() {
        String[] line = new String[]{"-host=localhost", "-v", "--port", "1234", "param1", "-name=Something", "param2"};
        Args args = Args.parse((String[])line);
        Assert.assertEquals((Object)"localhost", (Object)args.get("host", null));
        Assert.assertTrue((boolean)args.has("v"));
        Assert.assertEquals((long)1234L, (long)args.getNumber("port", null).intValue());
        Assert.assertEquals((Object)"Something", (Object)args.get("name", null));
        Assert.assertEquals((long)2L, (long)args.orphans().size());
        Assert.assertEquals((Object)"param1", args.orphans().get(0));
        Assert.assertEquals((Object)"param2", args.orphans().get(1));
    }

    @Test
    public void testParameterWithDashValue() {
        String[] line = new String[]{"-file", "-"};
        Args args = Args.parse((String[])line);
        Assert.assertEquals((long)1L, (long)args.asMap().size());
        Assert.assertEquals((Object)"-", (Object)args.get("file", null));
        Assert.assertTrue((boolean)args.orphans().isEmpty());
    }

    @Test
    public void testEnum() {
        String[] line = new String[]{"--enum=" + MyEnum.second.name()};
        Args args = Args.parse((String[])line);
        Enum result = args.getEnum(MyEnum.class, "enum", (Enum)MyEnum.first);
        Assert.assertEquals((Object)((Object)MyEnum.second), (Object)result);
    }

    @Test
    public void testEnumWithDefault() {
        String[] line = new String[]{};
        Args args = Args.parse((String[])line);
        MyEnum result = (MyEnum)args.getEnum(MyEnum.class, "enum", (Enum)MyEnum.third);
        Assert.assertEquals((Object)((Object)MyEnum.third), (Object)((Object)result));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumWithInvalidValue() {
        String[] line = new String[]{"--myenum=something"};
        Args args = Args.parse((String[])line);
        args.getEnum(MyEnum.class, "myenum", (Enum)MyEnum.third);
    }

    @Test
    public void shouldInterpretOption() {
        int expectedValue = 42;
        Args args = Args.parse((String[])new String[]{"--arg", String.valueOf(expectedValue)});
        Validator validator = (Validator)Mockito.mock(Validator.class);
        int value = (Integer)args.interpretOption("arg", Converters.mandatory(), Converters.toInt(), new Validator[]{validator});
        Assert.assertEquals((long)expectedValue, (long)value);
        ((Validator)Mockito.verify((Object)validator)).validate((Object)expectedValue);
    }

    @Test
    public void shouldInterpretOrphan() {
        int expectedValue = 42;
        Args args = Args.parse((String[])new String[]{String.valueOf(expectedValue)});
        Validator validator = (Validator)Mockito.mock(Validator.class);
        int value = (Integer)args.interpretOrphan(0, Converters.mandatory(), Converters.toInt(), new Validator[]{validator});
        Assert.assertEquals((long)expectedValue, (long)value);
        ((Validator)Mockito.verify((Object)validator)).validate((Object)expectedValue);
    }

    @Test
    public void shouldInterpretMultipleOptionValues() {
        List<Integer> expectedValues = Arrays.asList(12, 34, 56);
        ArrayList<String> argList = new ArrayList<String>();
        String key = "number";
        Iterator iterator = expectedValues.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            argList.add("--" + key);
            argList.add(String.valueOf(value));
        }
        Args args = Args.parse((String[])argList.toArray(new String[argList.size()]));
        try {
            args.get(key);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException value) {
            // empty catch block
        }
        Collection numbers = args.interpretOptions(key, Converters.optional(), Converters.toInt(), new Validator[0]);
        Assert.assertEquals(expectedValues, (Object)numbers);
    }

    @Test
    public void testBooleanWithDefault() {
        Args args = Args.parse((String[])new String[]{"--no_value"});
        Assert.assertThat((Object)args.getBoolean("not_set", Boolean.valueOf(true), Boolean.valueOf(true)), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)args.getBoolean("not_set", Boolean.valueOf(false), Boolean.valueOf(true)), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)args.getBoolean("not_set", Boolean.valueOf(false), Boolean.valueOf(false)), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)args.getBoolean("not_set", Boolean.valueOf(true), Boolean.valueOf(false)), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)args.getBoolean("no_value", Boolean.valueOf(true), Boolean.valueOf(true)), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)args.getBoolean("no_value", Boolean.valueOf(false), Boolean.valueOf(true)), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)args.getBoolean("no_value", Boolean.valueOf(false), Boolean.valueOf(false)), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)args.getBoolean("no_value", Boolean.valueOf(true), Boolean.valueOf(false)), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldGetAsMap() {
        Args args = Args.parse((String[])new String[]{"--with-value", "value", "--without-value"});
        Map map = args.asMap();
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"with-value", "value", "without-value", null}), (Object)map);
    }

    @Test
    public void shouldInterpretOptionMetadata() {
        Args args = Args.parse((String[])new String[]{"--my-option:Meta", "my value", "--my-option:Other", "other value"});
        Collection options = args.interpretOptionsWithMetadata("my-option", Converters.mandatory(), value -> value, new Validator[0]);
        Assert.assertEquals((long)2L, (long)options.size());
        Iterator optionIterator = options.iterator();
        Args.Option first = (Args.Option)optionIterator.next();
        Assert.assertEquals((Object)"my value", (Object)first.value());
        Assert.assertEquals((Object)"Meta", (Object)first.metadata());
        Args.Option second = (Args.Option)optionIterator.next();
        Assert.assertEquals((Object)"other value", (Object)second.value());
        Assert.assertEquals((Object)"Other", (Object)second.metadata());
    }

    @Test
    public void shouldHandleLastOrphanParam() {
        Args args = Args.withFlags((String[])new String[]{"recovery"}).parse(new String[]{"--recovery", "/tmp/graph.db"});
        List orphans = args.orphans();
        Assert.assertEquals(Arrays.asList("/tmp/graph.db"), (Object)orphans);
    }

    @Test
    public void shouldHandleOnlyFlagsAndNoArgs() {
        Args args = Args.withFlags((String[])new String[]{"foo", "bar"}).parse(new String[]{"-foo", "--bar"});
        List orphans = args.orphans();
        Assert.assertEquals(Collections.emptyList(), (Object)orphans);
        Assert.assertTrue((boolean)args.getBoolean("foo", Boolean.valueOf(false), Boolean.valueOf(true)));
        Assert.assertTrue((boolean)args.getBoolean("bar", Boolean.valueOf(false), Boolean.valueOf(true)));
    }

    @Test
    public void shouldStillAllowExplicitValuesForFlags() {
        Args args = Args.withFlags((String[])new String[]{"foo", "bar"}).parse(new String[]{"-foo=false", "--bar"});
        List orphans = args.orphans();
        Assert.assertEquals(Arrays.asList(new String[0]), (Object)orphans);
        Assert.assertFalse((boolean)args.getBoolean("foo", Boolean.valueOf(false), Boolean.valueOf(false)));
        Assert.assertTrue((boolean)args.getBoolean("bar", Boolean.valueOf(false), Boolean.valueOf(true)));
    }

    @Test
    public void shouldHandleMixtureOfFlagsAndOrphanParams() {
        Args args = Args.withFlags((String[])new String[]{"big", "soft", "saysMeow"}).parse(new String[]{"-big", "-size=120", "-soft=true", "withStripes", "-saysMeow=false", "-name=ShereKhan", "badTiger"});
        List orphans = args.orphans();
        Assert.assertEquals(Arrays.asList("withStripes", "badTiger"), (Object)orphans);
        Assert.assertEquals((long)120L, (long)args.getNumber("size", (Number)0).intValue());
        Assert.assertEquals((Object)"ShereKhan", (Object)args.get("name"));
        Assert.assertTrue((boolean)args.getBoolean("big", Boolean.valueOf(false), Boolean.valueOf(true)));
        Assert.assertTrue((boolean)args.getBoolean("soft", Boolean.valueOf(false), Boolean.valueOf(false)));
        Assert.assertFalse((boolean)args.getBoolean("saysMeow", Boolean.valueOf(true), Boolean.valueOf(true)));
    }

    @Test
    public void shouldHandleFlagSpecifiedAsLastArgument() {
        Args args = Args.withFlags((String[])new String[]{"flag1", "flag2"}).parse(new String[]{"-key=Foo", "-flag1", "false", "-value", "Bar", "-flag2", "false"});
        List orphans = args.orphans();
        Assert.assertTrue((String)("Orphan args expected to be empty, but were: " + orphans), (boolean)orphans.isEmpty());
        Assert.assertEquals((Object)"Foo", (Object)args.get("key"));
        Assert.assertEquals((Object)"Bar", (Object)args.get("value"));
        Assert.assertFalse((String)"flag1", (boolean)args.getBoolean("flag1", Boolean.valueOf(true)));
        Assert.assertFalse((String)"flag1", (boolean)args.getBoolean("flag2", Boolean.valueOf(true)));
    }

    @Test
    public void shouldRecognizeFlagsOfAnyForm() {
        Args args = Args.withFlags((String[])new String[]{"flag1", "flag2", "flag3"}).parse(new String[]{"-key1=Foo", "-flag1", "-key1", "Bar", "-flag2=true", "-key3=Baz", "-flag3", "true"});
        List orphans = args.orphans();
        Assert.assertTrue((String)("Orphan args expected to be empty, but were: " + orphans), (boolean)orphans.isEmpty());
        Assert.assertTrue((boolean)args.getBoolean("flag1", Boolean.valueOf(false), Boolean.valueOf(true)));
        Assert.assertTrue((boolean)args.getBoolean("flag2", Boolean.valueOf(false), Boolean.valueOf(false)));
        Assert.assertTrue((boolean)args.getBoolean("flag3", Boolean.valueOf(false), Boolean.valueOf(false)));
    }

    @Test
    public void shouldReturnEmptyCollectionForOptionalMissingOption() {
        Args args = Args.withFlags((String[])new String[0]).parse(new String[0]);
        Collection interpreted = args.interpretOptions("something", Converters.optional(), value -> value, new Validator[0]);
        Assert.assertTrue((boolean)interpreted.isEmpty());
    }

    private static enum MyEnum {
        first,
        second,
        third;

    }
}

