/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public abstract class CompositeIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public CompositeIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, SchemaIndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void testIndexSeekAndScanByString() throws Exception {
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), "a", "a"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), "b", "b"), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), "a", "b")));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, "a"), IndexQueryHelper.exact(1, "a")), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, "b"), IndexQueryHelper.exact(1, "b")), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, "a"), IndexQueryHelper.exact(1, "b")), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Test
    public void testIndexSeekAndScanByNumber() throws Exception {
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), 333, 333), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), 101, 101), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), 333, 101)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, 333), IndexQueryHelper.exact(1, 333)), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, 101), IndexQueryHelper.exact(1, 101)), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, 333), IndexQueryHelper.exact(1, 101)), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Test
    public void testIndexSeekAndScanByPoint() throws Exception {
        PointValue gps = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.6, 56.7});
        PointValue car = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{12.6, 56.7});
        PointValue gps3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.6, 56.7, 100.0});
        PointValue car3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{12.6, 56.7, 100.0});
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), gps, gps), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), car, car), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), gps, car), CompositeIndexAccessorCompatibility.add(4L, this.descriptor.schema(), gps3d, gps3d), CompositeIndexAccessorCompatibility.add(5L, this.descriptor.schema(), car3d, car3d), CompositeIndexAccessorCompatibility.add(6L, this.descriptor.schema(), gps, car3d)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, gps), IndexQueryHelper.exact(1, gps)), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, car), IndexQueryHelper.exact(1, car)), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, gps), IndexQueryHelper.exact(1, car)), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, gps3d), IndexQueryHelper.exact(1, gps3d)), (Matcher)Matchers.equalTo(Collections.singletonList(4L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, car3d), IndexQueryHelper.exact(1, car3d)), (Matcher)Matchers.equalTo(Collections.singletonList(5L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact(0, gps), IndexQueryHelper.exact(1, car3d)), (Matcher)Matchers.equalTo(Collections.singletonList(6L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L)));
    }

    private static IndexEntryUpdate<SchemaDescriptor> add(long nodeId, SchemaDescriptor schema, Object value1, Object value2) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)schema, (Value[])new Value[]{Values.of((Object)value1), Values.of((Object)value2)});
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends CompositeIndexAccessorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, SchemaIndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), "a", "a"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), "a", "a")));
            Assert.assertThat(this.query(IndexQueryHelper.exact(0, "a"), IndexQueryHelper.exact(1, "a")), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends CompositeIndexAccessorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, SchemaIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void testDuplicatesInIndexSeekByString() throws Exception {
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), "a", "a"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), "a", "a")));
            Assert.assertThat(this.query(IndexQueryHelper.exact(0, "a"), IndexQueryHelper.exact(1, "a")), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }

        @Test
        public void testDuplicatesInIndexSeekByNumber() throws Exception {
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), 333, 333), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), 333, 333)));
            Assert.assertThat(this.query(IndexQueryHelper.exact(0, 333), IndexQueryHelper.exact(1, 333)), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }

        @Test
        public void testDuplicatesInIndexSeekByPoint() throws Exception {
            PointValue gps = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.6, 56.7});
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), gps, gps), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), gps, gps)));
            Assert.assertThat(this.query(IndexQueryHelper.exact(0, gps), IndexQueryHelper.exact(1, gps)), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }
    }
}

