/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.inmemory.UpdateCapturingIndexAccessor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;

public class UpdateCapturingIndexProvider
extends IndexProvider {
    private final IndexProvider actual;
    private final Map<Long, UpdateCapturingIndexAccessor> indexes = new ConcurrentHashMap<Long, UpdateCapturingIndexAccessor>();
    private final Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates;

    public UpdateCapturingIndexProvider(IndexProvider actual, Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates) {
        super(actual);
        this.actual = actual;
        this.initialUpdates = initialUpdates;
    }

    public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return this.actual.getPopulator(indexId, descriptor, samplingConfig);
    }

    public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        IndexAccessor actualAccessor = this.actual.getOnlineAccessor(indexId, descriptor, samplingConfig);
        return this.indexes.computeIfAbsent(indexId, id -> new UpdateCapturingIndexAccessor(actualAccessor, this.initialUpdates.get(id)));
    }

    public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
        return this.actual.getPopulationFailure(indexId, descriptor);
    }

    public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
        return this.actual.getInitialState(indexId, descriptor);
    }

    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        return this.actual.getCapability(schemaIndexDescriptor);
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return this.actual.storeMigrationParticipant(fs, pageCache);
    }

    public Map<Long, Collection<IndexEntryUpdate<?>>> snapshot() {
        HashMap result = new HashMap();
        this.indexes.forEach((indexId, index) -> result.put((Long)indexId, index.snapshot()));
        return result;
    }
}

