/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.api.store.StorePropertyPayloadCursor;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.StandaloneDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Enclosed.class)
public class StorePropertyPayloadCursorTest {
    private static StorePropertyPayloadCursor newCursor(Params input) {
        return StorePropertyPayloadCursorTest.newCursor(input.params);
    }

    private static StorePropertyPayloadCursor newCursor(Param ... params) {
        Object[] values = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            values[i] = params[i].value;
        }
        return StorePropertyPayloadCursorTest.newCursor(values);
    }

    private static StorePropertyPayloadCursor newCursor(Object ... values) {
        DynamicStringStore dynamicStringStore = (DynamicStringStore)Mockito.mock(DynamicStringStore.class);
        DynamicArrayStore dynamicArrayStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);
        return StorePropertyPayloadCursorTest.newCursor(dynamicStringStore, dynamicArrayStore, values);
    }

    private static StorePropertyPayloadCursor newCursor(DynamicStringStore dynamicStringStore, DynamicArrayStore dynamicArrayStore, Object ... values) {
        StorePropertyPayloadCursor cursor = new StorePropertyPayloadCursor(dynamicStringStore.newRecordCursor((AbstractBaseRecord)new DynamicRecord(-1L)), dynamicArrayStore.newRecordCursor((AbstractBaseRecord)new DynamicRecord(-1L)));
        long[] blocks = StorePropertyPayloadCursorTest.asBlocks(values);
        cursor.init(blocks, blocks.length);
        return cursor;
    }

    private static long[] asBlocks(Object ... values) {
        StandaloneDynamicRecordAllocator stringAllocator = new StandaloneDynamicRecordAllocator();
        StandaloneDynamicRecordAllocator arrayAllocator = new StandaloneDynamicRecordAllocator();
        long[] blocks = new long[PropertyType.getPayloadSizeLongs()];
        int cursor = 0;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            PropertyBlock block = new PropertyBlock();
            PropertyStore.encodeValue((PropertyBlock)block, (int)i, (Value)Values.of((Object)value), (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator, (boolean)true);
            long[] valueBlocks = block.getValueBlocks();
            System.arraycopy(valueBlocks, 0, blocks, cursor, valueBlocks.length);
            cursor += valueBlocks.length;
        }
        return blocks;
    }

    private static <S extends AbstractDynamicStore> S newDynamicStoreMock(Class<S> clazz) {
        RecordCursor recordCursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        Mockito.when((Object)recordCursor.next()).thenReturn((Object)true).thenReturn((Object)false);
        DynamicRecord dynamicRecord = new DynamicRecord(42L);
        dynamicRecord.setData(new byte[]{1, 1, 1, 1, 1});
        Mockito.when((Object)recordCursor.get()).thenReturn((Object)dynamicRecord);
        Mockito.when((Object)recordCursor.acquire(ArgumentMatchers.anyLong(), (RecordLoad)ArgumentMatchers.any(RecordLoad.class))).thenReturn((Object)recordCursor);
        AbstractDynamicStore store = (AbstractDynamicStore)Mockito.mock(clazz);
        Mockito.when((Object)store.newRecordCursor((AbstractBaseRecord)ArgumentMatchers.any(DynamicRecord.class))).thenReturn((Object)recordCursor);
        return (S)store;
    }

    static class Params
    implements Iterable<Param> {
        final Param[] params;

        Params(Param[] params) {
            this.params = params;
        }

        static Object[] params(Param ... input) {
            return new Object[]{new Params(input)};
        }

        @Override
        public Iterator<Param> iterator() {
            return Iterators.iterator((Object[])this.params);
        }

        public String toString() {
            return "{params=" + Arrays.toString(this.params) + "}";
        }
    }

    static class Param {
        final Object value;
        final PropertyType type;

        Param(Object value, PropertyType type) {
            this.value = value;
            this.type = type;
        }

        static Object[] param(Object value, PropertyType type) {
            return new Object[]{Param.paramArg(value, type)};
        }

        static Param paramArg(Object value, PropertyType type) {
            return new Param(value, type);
        }

        public String toString() {
            return "{type=" + this.type + ", value=" + Strings.prettyPrint((Object)this.value) + "}";
        }
    }

    @RunWith(value=Parameterized.class)
    public static class MultipleValuePayload {
        @Parameterized.Parameter(value=0)
        public Params parameters;

        @Parameterized.Parameters(name="{0}")
        public static List<Object[]> parameters() {
            return Arrays.asList(Params.params(Param.paramArg(false, PropertyType.BOOL), Param.paramArg(true, PropertyType.BOOL)), Params.params(Param.paramArg((byte)24, PropertyType.BYTE), Param.paramArg((byte)-128, PropertyType.BYTE)), Params.params(Param.paramArg((short)99, PropertyType.SHORT), Param.paramArg((short)Short.MAX_VALUE, PropertyType.SHORT)), Params.params(Param.paramArg(Character.valueOf('c'), PropertyType.CHAR), Param.paramArg(Character.valueOf('\udbff'), PropertyType.CHAR)), Params.params(Param.paramArg(10293, PropertyType.INT), Param.paramArg(Integer.MIN_VALUE, PropertyType.INT)), Params.params(Param.paramArg(Float.valueOf(564.29395f), PropertyType.FLOAT), Param.paramArg(Float.valueOf(Float.MAX_VALUE), PropertyType.FLOAT)), Params.params(Param.paramArg(Double.MAX_VALUE, PropertyType.DOUBLE), Param.paramArg(Double.MIN_VALUE, PropertyType.DOUBLE)), Params.params(Param.paramArg(Long.MIN_VALUE, PropertyType.LONG), Param.paramArg(Long.MAX_VALUE, PropertyType.LONG)), Params.params(Param.paramArg(new boolean[]{true}, PropertyType.SHORT_ARRAY), Param.paramArg(new byte[]{-6}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(new short[]{12000}, PropertyType.SHORT_ARRAY), Param.paramArg(new short[]{Short.MIN_VALUE}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(new char[]{'T'}, PropertyType.SHORT_ARRAY), Param.paramArg(new int[]{314}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(new float[]{3.14f}, PropertyType.SHORT_ARRAY), Param.paramArg(new long[]{1234567890123L}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(new double[]{Double.MIN_VALUE}, PropertyType.SHORT_ARRAY), Param.paramArg(new long[]{Long.MAX_VALUE}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(new long[]{1234567890123L}, PropertyType.SHORT_ARRAY), Param.paramArg(new long[]{Long.MIN_VALUE}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(new long[]{1234567890123L}, PropertyType.SHORT_ARRAY), Param.paramArg(new long[]{Long.MIN_VALUE}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(false, PropertyType.BOOL), Param.paramArg(true, PropertyType.BOOL), Param.paramArg(false, PropertyType.BOOL), Param.paramArg(true, PropertyType.BOOL)), Params.params(Param.paramArg((byte)24, PropertyType.BYTE), Param.paramArg(true, PropertyType.BOOL), Param.paramArg((short)99, PropertyType.SHORT)), Params.params(Param.paramArg((byte)-128, PropertyType.BYTE), Param.paramArg((byte)127, PropertyType.BYTE), Param.paramArg((short)99, PropertyType.SHORT), Param.paramArg(true, PropertyType.BOOL)), Params.params(Param.paramArg((short)99, PropertyType.SHORT), Param.paramArg((byte)1, PropertyType.BYTE), Param.paramArg((short)Short.MIN_VALUE, PropertyType.SHORT), Param.paramArg((short)Short.MAX_VALUE, PropertyType.SHORT)), Params.params(Param.paramArg((short)Short.MAX_VALUE, PropertyType.SHORT), Param.paramArg(5L, PropertyType.LONG), Param.paramArg(6L, PropertyType.LONG)), Params.params(Param.paramArg(Character.valueOf('c'), PropertyType.CHAR), Param.paramArg(Character.valueOf('h'), PropertyType.CHAR), Param.paramArg(Character.valueOf('a'), PropertyType.CHAR), Param.paramArg(Character.valueOf('r'), PropertyType.CHAR)), Params.params(Param.paramArg(10293, PropertyType.INT), Param.paramArg(Character.valueOf('r'), PropertyType.CHAR), Param.paramArg(3.14, PropertyType.DOUBLE)), Params.params(Param.paramArg(Integer.MIN_VALUE, PropertyType.INT), Param.paramArg(Integer.MAX_VALUE, PropertyType.INT), Param.paramArg(Integer.MAX_VALUE, PropertyType.INT), Param.paramArg(Integer.MAX_VALUE, PropertyType.INT)), Params.params(Param.paramArg(Float.valueOf(Float.MIN_VALUE), PropertyType.FLOAT), Param.paramArg(Float.valueOf(256.256f), PropertyType.FLOAT)), Params.params(Param.paramArg(1.0, PropertyType.DOUBLE), Param.paramArg(Double.MAX_VALUE, PropertyType.DOUBLE)), Params.params(Param.paramArg(Double.MIN_VALUE, PropertyType.DOUBLE), Param.paramArg((short)Short.MAX_VALUE, PropertyType.SHORT), Param.paramArg((byte)127, PropertyType.BYTE)), Params.params(Param.paramArg(484381293L, PropertyType.LONG), Param.paramArg(Character.valueOf('c'), PropertyType.CHAR), Param.paramArg(1, PropertyType.INT), Param.paramArg(true, PropertyType.BOOL)), Params.params(Param.paramArg(Character.valueOf('s'), PropertyType.CHAR), Param.paramArg(Character.valueOf('o'), PropertyType.CHAR), Param.paramArg("rt", PropertyType.SHORT_STRING), Param.paramArg(true, PropertyType.BOOL)), Params.params(Param.paramArg("abc", PropertyType.SHORT_STRING), Param.paramArg(11L, PropertyType.LONG)), Params.params(Param.paramArg(new boolean[]{true}, PropertyType.SHORT_ARRAY), Param.paramArg(new boolean[]{true, false, false}, PropertyType.SHORT_ARRAY), Param.paramArg(new byte[]{0}, PropertyType.SHORT_ARRAY)), Params.params(Param.paramArg(new byte[]{-6, -5, -4}, PropertyType.SHORT_ARRAY), Param.paramArg(new char[]{'C', 'T'}, PropertyType.SHORT_ARRAY), Param.paramArg(true, PropertyType.BOOL)), Params.params(Param.paramArg(new long[]{1234567890123L, Long.MAX_VALUE}, PropertyType.SHORT_ARRAY), Param.paramArg((byte)42, PropertyType.BYTE)));
        }

        @Test
        public void shouldReturnCorrectValues() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(this.parameters);
            for (Param param : this.parameters) {
                boolean next = cursor.next();
                Assert.assertTrue((boolean)next);
                Assert.assertEquals((Object)param.type, (Object)cursor.type());
                Assert.assertEquals((Object)Values.of((Object)param.value), (Object)cursor.value());
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SingleValuePayload {
        @Parameterized.Parameter(value=0)
        public Param param;

        @Parameterized.Parameters(name="{0}")
        public static List<Object[]> parameters() {
            return Arrays.asList(Param.param(false, PropertyType.BOOL), Param.param(true, PropertyType.BOOL), Param.param((byte)24, PropertyType.BYTE), Param.param((byte)-128, PropertyType.BYTE), Param.param((byte)127, PropertyType.BYTE), Param.param((short)99, PropertyType.SHORT), Param.param((short)Short.MIN_VALUE, PropertyType.SHORT), Param.param((short)Short.MAX_VALUE, PropertyType.SHORT), Param.param(Character.valueOf('c'), PropertyType.CHAR), Param.param(Character.valueOf('\udc00'), PropertyType.CHAR), Param.param(Character.valueOf('\udbff'), PropertyType.CHAR), Param.param(10293, PropertyType.INT), Param.param(Integer.MIN_VALUE, PropertyType.INT), Param.param(Integer.MAX_VALUE, PropertyType.INT), Param.param(Float.valueOf(564.29395f), PropertyType.FLOAT), Param.param(Float.valueOf(Float.MIN_VALUE), PropertyType.FLOAT), Param.param(Float.valueOf(Float.MAX_VALUE), PropertyType.FLOAT), Param.param(9.303917312848E7, PropertyType.DOUBLE), Param.param(Double.MIN_VALUE, PropertyType.DOUBLE), Param.param(Double.MAX_VALUE, PropertyType.DOUBLE), Param.param(484381293L, PropertyType.LONG), Param.param(Long.MIN_VALUE, PropertyType.LONG), Param.param(Long.MAX_VALUE, PropertyType.LONG), Param.param("short", PropertyType.SHORT_STRING), Param.param("alongershortstring", PropertyType.SHORT_STRING), Param.param("areallylongshortstringbutstillnotsobig", PropertyType.SHORT_STRING), Param.param(new boolean[]{true}, PropertyType.SHORT_ARRAY), Param.param(new byte[]{-6}, PropertyType.SHORT_ARRAY), Param.param(new short[]{12000}, PropertyType.SHORT_ARRAY), Param.param(new char[]{'T'}, PropertyType.SHORT_ARRAY), Param.param(new int[]{314}, PropertyType.SHORT_ARRAY), Param.param(new float[]{3.14f}, PropertyType.SHORT_ARRAY), Param.param(new double[]{314159.2653}, PropertyType.SHORT_ARRAY), Param.param(new long[]{1234567890123L}, PropertyType.SHORT_ARRAY));
        }

        @Test
        public void shouldReturnCorrectSingleValue() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Param[]{this.param});
            boolean next = cursor.next();
            Assert.assertTrue((boolean)next);
            Assert.assertEquals((Object)this.param.type, (Object)cursor.type());
            Assert.assertEquals((Object)Values.of((Object)this.param.value), (Object)cursor.value());
        }
    }

    public static class BasicContract {
        @Test
        public void nextShouldAlwaysReturnFalseWhenNotInitialized() {
            StorePropertyPayloadCursor cursor = new StorePropertyPayloadCursor((RecordCursor)Mockito.mock(RecordCursor.class), (RecordCursor)Mockito.mock(RecordCursor.class));
            Assert.assertFalse((boolean)cursor.next());
            Assert.assertFalse((boolean)cursor.next());
        }

        @Test
        public void nextShouldAlwaysReturnFalseWhenCleared() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Object[]{"cat-dog"});
            Assert.assertTrue((boolean)cursor.next());
            cursor.clear();
            Assert.assertFalse((boolean)cursor.next());
            Assert.assertFalse((boolean)cursor.next());
        }

        @Test
        public void shouldBeOkToClearUnusedCursor() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Object[]{"cat-dog"});
            cursor.clear();
        }

        @Test
        public void shouldBeOkToClearPartiallyExhaustedCursor() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Object[]{1, 2, 3L});
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)cursor.next());
            cursor.clear();
        }

        @Test
        public void shouldBeOkToClearExhaustedCursor() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Object[]{1, 2, 3});
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)cursor.next());
            cursor.clear();
        }

        @Test
        public void shouldBePossibleToCallClearOnEmptyCursor() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Param[0]);
            cursor.clear();
        }

        @Test
        public void shouldBePossibleToCallNextOnEmptyCursor() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Param[0]);
            Assert.assertFalse((boolean)cursor.next());
        }

        @Test
        public void shouldUseDynamicStringAndArrayStoresThroughDifferentCursors() {
            DynamicStringStore dynamicStringStore = (DynamicStringStore)StorePropertyPayloadCursorTest.newDynamicStoreMock(DynamicStringStore.class);
            DynamicArrayStore dynamicArrayStore = (DynamicArrayStore)StorePropertyPayloadCursorTest.newDynamicStoreMock(DynamicArrayStore.class);
            String string = RandomStringUtils.randomAlphanumeric((int)5000);
            byte[] array = RandomStringUtils.randomAlphanumeric((int)10000).getBytes();
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(dynamicStringStore, dynamicArrayStore, new Object[]{string, array});
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertNotNull((Object)cursor.stringValue());
            Assert.assertNotEquals((Object)Values.NO_VALUE, (Object)cursor.stringValue());
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertNotNull((Object)cursor.arrayValue());
            Assert.assertFalse((boolean)cursor.next());
            ((DynamicStringStore)Mockito.verify((Object)dynamicStringStore)).newRecordCursor((AbstractBaseRecord)ArgumentMatchers.any(DynamicRecord.class));
            ((DynamicArrayStore)Mockito.verify((Object)dynamicArrayStore)).newRecordCursor((AbstractBaseRecord)ArgumentMatchers.any(DynamicRecord.class));
        }

        @Test
        public void nextMultipleInvocations() {
            StorePropertyPayloadCursor cursor = StorePropertyPayloadCursorTest.newCursor(new Param[0]);
            Assert.assertFalse((boolean)cursor.next());
            Assert.assertFalse((boolean)cursor.next());
            Assert.assertFalse((boolean)cursor.next());
            Assert.assertFalse((boolean)cursor.next());
        }
    }
}

