/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.index.GBPTreeFileUtil;

public abstract class AbstractGBPTreeFileUtilTest {
    private GBPTreeFileUtil fileUtil;
    private File existingFile;
    private File nonExistingFile;
    private File nonExistingDirectory;

    @Before
    public void setup() throws IOException {
        this.fileUtil = this.getGBPTreeFileUtil();
        this.existingFile = this.existingFile("existing_file");
        this.nonExistingFile = this.nonExistingFile("non_existing_file");
        this.nonExistingDirectory = this.nonExistingDirectory("non_existing_directory");
    }

    @After
    public void cleanUp() {
    }

    protected abstract GBPTreeFileUtil getGBPTreeFileUtil();

    protected abstract File existingFile(String var1) throws IOException;

    protected abstract File nonExistingFile(String var1);

    protected abstract File nonExistingDirectory(String var1);

    protected abstract void assertFileDoesNotExist(File var1);

    protected abstract void assertDirectoryExist(File var1);

    @Test
    public void fileMustNotExistAfterDeleteFile() throws Exception {
        this.fileUtil.deleteFile(this.existingFile);
        this.assertFileDoesNotExist(this.existingFile);
    }

    @Test
    public void deleteFileMustThrowIfFileIsMissing() throws Exception {
        try {
            this.fileUtil.deleteFile(this.nonExistingFile);
            Assert.fail((String)"Should have failed");
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    public void deleteFileIfPresentMustDeleteFileIfPresent() throws Exception {
        this.fileUtil.deleteFileIfPresent(this.existingFile);
        this.assertFileDoesNotExist(this.existingFile);
    }

    @Test
    public void deleteFileIfPresentMustNotThrowIfFileIsMissing() throws Exception {
        this.fileUtil.deleteFileIfPresent(this.nonExistingFile);
    }

    @Test
    public void storeFileExistsMustReturnTrueForExistingFile() {
        Assert.assertTrue((boolean)this.fileUtil.storeFileExists(this.existingFile));
    }

    @Test
    public void storeFileExistsMustReturnFalseForNonExistingFile() {
        Assert.assertFalse((boolean)this.fileUtil.storeFileExists(this.nonExistingFile));
    }

    @Test
    public void directoryMustExistAfterMkdirs() throws Exception {
        this.fileUtil.mkdirs(this.nonExistingDirectory);
        this.assertDirectoryExist(this.nonExistingDirectory);
    }
}

