/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexProviderTest {
    @Rule
    public PageCacheAndDependenciesRule rules = new PageCacheAndDependenciesRule();
    private static final int indexId = 1;
    private static final int labelId = 1;
    private static final int propId = 1;
    private IndexProvider provider;
    private final AssertableLogProvider logging = new AssertableLogProvider();
    private final IndexProvider.Monitor monitor = new LoggingMonitor(this.logging.getLog("test"));

    @Before
    public void setup() throws IOException {
        File nativeSchemaIndexStoreDirectory = this.newProvider().directoryStructure().rootDirectory();
        this.rules.fileSystem().mkdirs(nativeSchemaIndexStoreDirectory);
    }

    @Test
    public void getPopulatorMustThrowIfInReadOnlyMode() {
        this.provider = this.newReadOnlyProvider();
        try {
            this.provider.getPopulator(1L, this.descriptor(), this.samplingConfig());
            Assert.fail((String)"Should have failed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotCheckConflictsWhenApplyingUpdatesInOnlineAccessor() throws IOException, IndexEntryConflictException {
        this.provider = this.newProvider();
        SchemaIndexDescriptor descriptor = this.descriptorUnique();
        try (IndexAccessor accessor = this.provider.getOnlineAccessor(1L, descriptor, this.samplingConfig());
             IndexUpdater indexUpdater = accessor.newUpdater(IndexUpdateMode.ONLINE);){
            Value value = this.someValue();
            indexUpdater.process(IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)descriptor.schema(), (Value[])new Value[]{value}));
            indexUpdater.process(IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)descriptor.schema(), (Value[])new Value[]{value}));
        }
    }

    @Test
    public void getPopulationFailureMustThrowIfNoFailure() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(1L, this.descriptor(), this.samplingConfig());
        populator.create();
        populator.close(true);
        try {
            this.provider.getPopulationFailure(1L, this.descriptor());
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)Long.toString(1L)));
        }
    }

    @Test
    public void getPopulationFailureMustThrowEvenIfFailureOnOtherIndex() throws IOException {
        this.provider = this.newProvider();
        int nonFailedIndexId = 1;
        IndexPopulator nonFailedPopulator = this.provider.getPopulator((long)nonFailedIndexId, this.descriptor(), this.samplingConfig());
        nonFailedPopulator.create();
        nonFailedPopulator.close(true);
        int failedIndexId = 2;
        IndexPopulator failedPopulator = this.provider.getPopulator((long)failedIndexId, this.descriptor(), this.samplingConfig());
        failedPopulator.create();
        failedPopulator.markAsFailed("failure");
        failedPopulator.close(false);
        try {
            this.provider.getPopulationFailure((long)nonFailedIndexId, this.descriptor());
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)Long.toString(nonFailedIndexId)));
        }
    }

    @Test
    public void getPopulationFailureMustReturnReportedFailure() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(1L, this.descriptor(), this.samplingConfig());
        populator.create();
        String failureMessage = "fail";
        populator.markAsFailed(failureMessage);
        populator.close(false);
        String populationFailure = this.provider.getPopulationFailure(1L, this.descriptor());
        Assert.assertThat((Object)populationFailure, (Matcher)CoreMatchers.is((Object)failureMessage));
    }

    @Test
    public void getPopulationFailureMustReturnReportedFailuresForDifferentIndexIds() throws IOException {
        this.provider = this.newProvider();
        int first = 1;
        int second = 2;
        int third = 3;
        IndexPopulator firstPopulator = this.provider.getPopulator((long)first, this.descriptor(), this.samplingConfig());
        firstPopulator.create();
        IndexPopulator secondPopulator = this.provider.getPopulator((long)second, this.descriptor(), this.samplingConfig());
        secondPopulator.create();
        IndexPopulator thirdPopulator = this.provider.getPopulator((long)third, this.descriptor(), this.samplingConfig());
        thirdPopulator.create();
        String firstFailure = "first failure";
        firstPopulator.markAsFailed(firstFailure);
        firstPopulator.close(false);
        secondPopulator.close(true);
        String thirdFailure = "third failure";
        thirdPopulator.markAsFailed(thirdFailure);
        thirdPopulator.close(false);
        Assert.assertThat((Object)this.provider.getPopulationFailure((long)first, this.descriptor()), (Matcher)CoreMatchers.is((Object)firstFailure));
        Assert.assertThat((Object)this.provider.getPopulationFailure((long)third, this.descriptor()), (Matcher)CoreMatchers.is((Object)thirdFailure));
        try {
            this.provider.getPopulationFailure((long)second, this.descriptor());
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getPopulationFailureMustPersistReportedFailure() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(1L, this.descriptor(), this.samplingConfig());
        populator.create();
        String failureMessage = "fail";
        populator.markAsFailed(failureMessage);
        populator.close(false);
        this.provider = this.newProvider();
        String populationFailure = this.provider.getPopulationFailure(1L, this.descriptor());
        Assert.assertThat((Object)populationFailure, (Matcher)CoreMatchers.is((Object)failureMessage));
    }

    @Test
    public void shouldReportCorrectInitialStateIfIndexDoesntExist() {
        this.provider = this.newProvider();
        InternalIndexState state = this.provider.getInitialState(1L, this.descriptor());
        InternalIndexState expected = this.expectedStateOnNonExistingSubIndex();
        Assert.assertEquals((Object)expected, (Object)state);
        if (InternalIndexState.POPULATING == expected) {
            this.logging.assertContainsLogCallContaining("Failed to open index");
        } else {
            this.logging.assertNoLogCallContaining("Failed to open index");
        }
    }

    @Test
    public void shouldReportInitialStateAsPopulatingIfPopulationStartedButIncomplete() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(1L, this.descriptor(), this.samplingConfig());
        populator.create();
        InternalIndexState state = this.provider.getInitialState(1L, this.descriptor());
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)state);
        populator.close(true);
    }

    @Test
    public void shouldReportInitialStateAsFailedIfMarkedAsFailed() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(1L, this.descriptor(), this.samplingConfig());
        populator.create();
        populator.markAsFailed("Just some failure");
        populator.close(false);
        InternalIndexState state = this.provider.getInitialState(1L, this.descriptor());
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)state);
    }

    @Test
    public void shouldReportInitialStateAsOnlineIfPopulationCompletedSuccessfully() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(1L, this.descriptor(), this.samplingConfig());
        populator.create();
        populator.close(true);
        InternalIndexState state = this.provider.getInitialState(1L, this.descriptor());
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)state);
    }

    protected abstract InternalIndexState expectedStateOnNonExistingSubIndex();

    protected abstract Value someValue();

    abstract IndexProvider newProvider(PageCache var1, FileSystemAbstraction var2, IndexDirectoryStructure.Factory var3, IndexProvider.Monitor var4, RecoveryCleanupWorkCollector var5);

    abstract IndexProvider newReadOnlyProvider(PageCache var1, FileSystemAbstraction var2, IndexDirectoryStructure.Factory var3, IndexProvider.Monitor var4, RecoveryCleanupWorkCollector var5);

    private IndexProvider newProvider() {
        return this.newProvider(this.pageCache(), this.fs(), IndexDirectoryStructure.directoriesByProvider((File)this.baseDir()), this.monitor, RecoveryCleanupWorkCollector.immediate());
    }

    private IndexProvider newReadOnlyProvider() {
        return this.newReadOnlyProvider(this.pageCache(), this.fs(), IndexDirectoryStructure.directoriesByProvider((File)this.baseDir()), this.monitor, RecoveryCleanupWorkCollector.immediate());
    }

    private IndexSamplingConfig samplingConfig() {
        return new IndexSamplingConfig(Config.defaults());
    }

    private SchemaIndexDescriptor descriptor() {
        return SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    }

    private SchemaIndexDescriptor descriptorUnique() {
        return SchemaIndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1});
    }

    private PageCache pageCache() {
        return this.rules.pageCache();
    }

    private FileSystemAbstraction fs() {
        return this.rules.fileSystem();
    }

    private File baseDir() {
        return this.rules.directory().absolutePath();
    }
}

