/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.participant.ExplicitIndexMigrator;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.upgrade.lucene.ExplicitIndexMigrationException;
import org.neo4j.upgrade.lucene.LuceneExplicitIndexUpgrader;

public class ExplicitIndexMigratorTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
    private final ProgressReporter progressMonitor = (ProgressReporter)Mockito.mock(ProgressReporter.class);
    private final File storeDir = (File)Mockito.mock(File.class);
    private final File migrationDir = (File)Mockito.mock(File.class);
    private final File originalIndexStore = (File)Mockito.mock(File.class);
    private final File migratedIndexStore = new File(".");

    @Before
    public void setUp() {
        Mockito.when((Object)this.originalIndexStore.getParentFile()).thenReturn((Object)this.storeDir);
        Mockito.when((Object)this.fs.isDirectory(this.originalIndexStore)).thenReturn((Object)true);
        Mockito.when((Object)this.fs.listFiles(this.originalIndexStore)).thenReturn((Object)new File[]{(File)Mockito.mock(File.class)});
    }

    @Test
    public void skipEmptyIndexStorageMigration() throws IOException {
        Mockito.when((Object)this.fs.listFiles(this.originalIndexStore)).thenReturn(null);
        HashMap<String, IndexImplementation> indexProviders = this.getIndexProviders();
        TestExplicitIndexMigrator indexMigrator = new TestExplicitIndexMigrator(this.fs, indexProviders, this.logProvider, true);
        indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressMonitor, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).deleteRecursively(this.originalIndexStore);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).moveToDirectory(this.migratedIndexStore, this.storeDir);
    }

    @Test
    public void transferOriginalDataToMigrationDirectory() throws IOException {
        HashMap<String, IndexImplementation> indexProviders = this.getIndexProviders();
        TestExplicitIndexMigrator indexMigrator = new TestExplicitIndexMigrator(this.fs, indexProviders, this.logProvider, true);
        indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressMonitor, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).copyRecursively(this.originalIndexStore, this.migratedIndexStore);
    }

    @Test
    public void transferMigratedIndexesToStoreDirectory() throws IOException {
        HashMap<String, IndexImplementation> indexProviders = this.getIndexProviders();
        TestExplicitIndexMigrator indexMigrator = new TestExplicitIndexMigrator(this.fs, indexProviders, this.logProvider, true);
        indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressMonitor, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        Mockito.reset((Object[])new FileSystemAbstraction[]{this.fs});
        indexMigrator.moveMigratedFiles(this.migrationDir, this.storeDir, "any", "any");
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(this.originalIndexStore);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).moveToDirectory(this.migratedIndexStore, this.storeDir);
    }

    @Test
    public void logErrorWithIndexNameOnIndexMigrationException() {
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)this.logProvider.getLog(TestExplicitIndexMigrator.class)).thenReturn((Object)log);
        HashMap<String, IndexImplementation> indexProviders = this.getIndexProviders();
        try {
            TestExplicitIndexMigrator indexMigrator = new TestExplicitIndexMigrator(this.fs, indexProviders, this.logProvider, false);
            indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressMonitor, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
            Assert.fail((String)"Index migration should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((Log)Mockito.verify((Object)log)).error((String)ArgumentMatchers.eq((Object)"Migration of explicit indexes failed. Index: testIndex can't be migrated."), (Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    public void cleanupMigrationDirectory() throws IOException {
        Mockito.when((Object)this.fs.fileExists(this.migratedIndexStore)).thenReturn((Object)true);
        HashMap<String, IndexImplementation> indexProviders = this.getIndexProviders();
        TestExplicitIndexMigrator indexMigrator = new TestExplicitIndexMigrator(this.fs, indexProviders, this.logProvider, true);
        indexMigrator.migrate(this.storeDir, this.migrationDir, this.progressMonitor, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        indexMigrator.cleanup(this.migrationDir);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(this.migratedIndexStore);
    }

    private HashMap<String, IndexImplementation> getIndexProviders() {
        HashMap<String, IndexImplementation> indexProviders = new HashMap<String, IndexImplementation>();
        IndexImplementation indexImplementation = (IndexImplementation)Mockito.mock(IndexImplementation.class);
        indexProviders.put("lucene", indexImplementation);
        Mockito.when((Object)indexImplementation.getIndexImplementationDirectory(this.storeDir)).thenReturn((Object)this.originalIndexStore);
        Mockito.when((Object)indexImplementation.getIndexImplementationDirectory(this.migrationDir)).thenReturn((Object)this.migratedIndexStore);
        return indexProviders;
    }

    private class HumbleExplicitIndexUpgrader
    extends LuceneExplicitIndexUpgrader {
        private final boolean successfulMigration;

        HumbleExplicitIndexUpgrader(Path indexRootPath, boolean successfulMigration) {
            super(indexRootPath, NO_MONITOR);
            this.successfulMigration = successfulMigration;
        }

        public void upgradeIndexes() throws ExplicitIndexMigrationException {
            if (!this.successfulMigration) {
                throw new ExplicitIndexMigrationException("testIndex", "Index migration failed", null);
            }
        }
    }

    private class TestExplicitIndexMigrator
    extends ExplicitIndexMigrator {
        private final boolean successfullMigration;

        TestExplicitIndexMigrator(FileSystemAbstraction fileSystem, Map<String, IndexImplementation> indexProviders, LogProvider logProvider, boolean successfullMigration) {
            super(fileSystem, indexProviders, logProvider);
            this.successfullMigration = successfullMigration;
        }

        LuceneExplicitIndexUpgrader createLuceneExplicitIndexUpgrader(Path indexRootPath, ProgressReporter progressReporter) {
            return new HumbleExplicitIndexUpgrader(indexRootPath, this.successfullMigration);
        }
    }
}

