/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.collection.ArrayCollection;

public class ArrayCollectionTest {
    @Test
    public void shouldAddItems() {
        ArrayCollection collection = new ArrayCollection(5);
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)collection.isEmpty());
        collection.add("1");
        collection.add("2");
        collection.add("3");
        Assert.assertTrue((boolean)collection.contains("1"));
        Assert.assertTrue((boolean)collection.contains("2"));
        Assert.assertTrue((boolean)collection.contains("3"));
        Assert.assertFalse((boolean)collection.contains("4"));
        Assert.assertEquals((long)3L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
    }

    @Test
    public void shouldGrowWithMoreItms() {
        int initialCapacity = 3;
        ArrayCollection collection = new ArrayCollection(initialCapacity);
        for (int i = 0; i < initialCapacity; ++i) {
            collection.add(i);
        }
        collection.add(10);
        Iterator iterator = collection.iterator();
        for (int i = 0; i < initialCapacity; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)iterator.next()).intValue());
        }
        Assert.assertEquals((long)10L, (long)((Integer)iterator.next()).intValue());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldClear() {
        int i;
        ArrayCollection collection = new ArrayCollection(10);
        for (i = 0; i < 5; ++i) {
            collection.add(String.valueOf(i));
        }
        collection.clear();
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertFalse((boolean)collection.iterator().hasNext());
        for (i = 50; i < 54; ++i) {
            collection.add(String.valueOf(i));
        }
        Iterator iterator = collection.iterator();
        Assert.assertEquals((Object)"50", iterator.next());
        Assert.assertEquals((Object)"51", iterator.next());
        Assert.assertEquals((Object)"52", iterator.next());
        Assert.assertEquals((Object)"53", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldAddAllBeyondCapacity() {
        ArrayCollection collection = new ArrayCollection(5);
        collection.addAll(this.intCollection(0, 15));
        Iterator iterator = collection.iterator();
        for (int i = 0; i < 15; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)iterator.next()).intValue());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private Collection<? extends Integer> intCollection(int startingAt, int size) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            ints.add(startingAt + i);
        }
        return ints;
    }
}

