/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

public class MonitorsTest {
    @Test
    public void shouldProvideNoOpDelegate() {
        Monitors monitors = new Monitors();
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, new Object());
    }

    @Test
    public void shouldRegister() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        Object obj = new Object();
        monitors.addMonitorListener((Object)listener, new String[0]);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, obj);
        ((MyMonitor)Mockito.verify((Object)listener)).aVoid();
        ((MyMonitor)Mockito.verify((Object)listener)).takesArgs("ha", 12L, obj);
    }

    @Test
    public void shouldUnregister() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        Object obj = new Object();
        monitors.addMonitorListener((Object)listener, new String[0]);
        monitors.removeMonitorListener((Object)listener);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, obj);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void shouldRespectTags() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitorTag1 = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[]{"tag1"});
        MyMonitor monitorTag2 = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[]{"tag2"});
        monitors.addMonitorListener((Object)listener, new String[]{"tag2"});
        monitorTag1.aVoid();
        Mockito.verifyZeroInteractions((Object[])new Object[]{listener});
        monitorTag2.aVoid();
        ((MyMonitor)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).aVoid();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void shouldTellIfMonitorHasListeners() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        monitors.newMonitor(MyMonitor.class, new String[0]);
        Assert.assertFalse((boolean)monitors.hasListeners(MyMonitor.class));
        monitors.addMonitorListener((Object)listener, new String[0]);
        Assert.assertTrue((boolean)monitors.hasListeners(MyMonitor.class));
        monitors.removeMonitorListener((Object)listener);
        Assert.assertFalse((boolean)monitors.hasListeners(MyMonitor.class));
    }

    @Test
    public void exceptionsInHandlersAreLogged() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream outputStream = new PrintStream(byteArrayOutputStream);
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)outputStream);
        Monitors monitors = new Monitors((LogProvider)logProvider);
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        RuntimeException runtimeException = new RuntimeException("Exception message");
        ((MyMonitor)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)listener)).aVoid();
        monitors.addMonitorListener((Object)listener, new String[0]);
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        monitor.aVoid();
        String logOutput = byteArrayOutputStream.toString();
        Assert.assertTrue((boolean)logOutput.contains("RuntimeException: Exception message"));
        Assert.assertTrue((boolean)logOutput.contains(this.getClass().getName()));
        Assert.assertTrue((boolean)logOutput.contains("Encountered exception while handling listener for monitor method aVoid"));
    }

    static interface MyMonitor {
        public void aVoid();

        public void takesArgs(String var1, long var2, Object ... var4);
    }
}

