/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.ExternalResource;
import org.neo4j.test.rule.TestDirectory;

public class NeoStoresRule
extends ExternalResource {
    private final Class<?> testClass;
    private NeoStores neoStores;
    private EphemeralFileSystemAbstraction ruleFs;
    private PageCache rulePageCache;
    private final StoreType[] stores;

    public NeoStoresRule(Class<?> testClass, StoreType ... stores) {
        this.testClass = testClass;
        this.stores = stores;
    }

    public Builder builder() {
        return new Builder();
    }

    private NeoStores open(FileSystemAbstraction fs, PageCache pageCache, RecordFormats format, Function<FileSystemAbstraction, IdGeneratorFactory> idGeneratorFactory, String ... config) throws IOException {
        assert (this.neoStores == null) : "Already opened";
        TestDirectory testDirectory = TestDirectory.testDirectory(this.testClass, (FileSystemAbstraction)fs);
        File storeDir = testDirectory.makeGraphDbDir();
        Config configuration = NeoStoresRule.configOf(config);
        StoreFactory storeFactory = new StoreFactory(storeDir, configuration, idGeneratorFactory.apply(fs), pageCache, fs, format, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.neoStores = this.stores.length == 0 ? storeFactory.openAllNeoStores(true) : storeFactory.openNeoStores(true, this.stores);
        return this.neoStores;
    }

    private static Config configOf(String ... config) {
        return Config.defaults((Map)MapUtil.stringMap((String[])config));
    }

    protected void after(boolean successful) throws Throwable {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.neoStores, this.rulePageCache});
        this.neoStores = null;
        if (this.ruleFs != null) {
            this.ruleFs.close();
        }
    }

    private static PageCache getOrCreatePageCache(Config config, FileSystemAbstraction fs) {
        NullLog log = NullLog.getInstance();
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)log, EmptyVersionContextSupplier.EMPTY);
        return pageCacheFactory.getOrCreatePageCache();
    }

    private PageCache rulePageCache(Config dbConfig, FileSystemAbstraction fs) {
        this.rulePageCache = NeoStoresRule.getOrCreatePageCache(dbConfig, fs);
        return this.rulePageCache;
    }

    private EphemeralFileSystemAbstraction ruleFs() {
        this.ruleFs = new EphemeralFileSystemAbstraction();
        return this.ruleFs;
    }

    public class Builder {
        private FileSystemAbstraction fs;
        private String[] config;
        private RecordFormats format;
        private PageCache pageCache;
        private Function<FileSystemAbstraction, IdGeneratorFactory> idGeneratorFactory;

        public Builder with(FileSystemAbstraction fs) {
            this.fs = fs;
            return this;
        }

        public Builder with(String ... config) {
            this.config = config;
            return this;
        }

        public Builder with(RecordFormats format) {
            this.format = format;
            return this;
        }

        public Builder with(PageCache pageCache) {
            this.pageCache = pageCache;
            return this;
        }

        public Builder with(Function<FileSystemAbstraction, IdGeneratorFactory> idGeneratorFactory) {
            this.idGeneratorFactory = idGeneratorFactory;
            return this;
        }

        public NeoStores build() throws IOException {
            if (this.fs == null) {
                this.fs = NeoStoresRule.this.ruleFs();
            }
            if (this.config == null) {
                this.config = new String[0];
            }
            Config dbConfig = NeoStoresRule.configOf(this.config);
            if (this.pageCache == null) {
                this.pageCache = NeoStoresRule.this.rulePageCache(dbConfig, this.fs);
            }
            if (this.format == null) {
                this.format = RecordFormatSelector.selectForConfig((Config)dbConfig, (LogProvider)NullLogProvider.getInstance());
            }
            if (this.idGeneratorFactory == null) {
                this.idGeneratorFactory = DefaultIdGeneratorFactory::new;
            }
            return NeoStoresRule.this.open(this.fs, this.pageCache, this.format, this.idGeneratorFactory, this.config);
        }
    }
}

