/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.input.EstimationSanityChecker;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;

public class EstimationSanityCheckerTest {
    @Test
    public void shouldWarnAboutCountGettingCloseToCapacity() {
        RecordFormats formats = Standard.LATEST_RECORD_FORMATS;
        ImportLogic.Monitor monitor = (ImportLogic.Monitor)Mockito.mock(ImportLogic.Monitor.class);
        Input.Estimates estimates = Inputs.knownEstimates((long)(formats.node().getMaxId() - 1000L), (long)(formats.relationship().getMaxId() - 1000L), (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
        new EstimationSanityChecker(formats, monitor).sanityCheck(estimates);
        ((ImportLogic.Monitor)Mockito.verify((Object)monitor)).mayExceedNodeIdCapacity(formats.node().getMaxId(), estimates.numberOfNodes());
        ((ImportLogic.Monitor)Mockito.verify((Object)monitor)).mayExceedRelationshipIdCapacity(formats.relationship().getMaxId(), estimates.numberOfRelationships());
    }

    @Test
    public void shouldWarnAboutCounthigherThanCapacity() {
        RecordFormats formats = Standard.LATEST_RECORD_FORMATS;
        ImportLogic.Monitor monitor = (ImportLogic.Monitor)Mockito.mock(ImportLogic.Monitor.class);
        Input.Estimates estimates = Inputs.knownEstimates((long)(formats.node().getMaxId() * 2L), (long)(formats.relationship().getMaxId() * 2L), (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
        new EstimationSanityChecker(formats, monitor).sanityCheck(estimates);
        ((ImportLogic.Monitor)Mockito.verify((Object)monitor)).mayExceedNodeIdCapacity(formats.node().getMaxId(), estimates.numberOfNodes());
        ((ImportLogic.Monitor)Mockito.verify((Object)monitor)).mayExceedRelationshipIdCapacity(formats.relationship().getMaxId(), estimates.numberOfRelationships());
    }

    @Test
    public void shouldNotWantIfCountWayLowerThanCapacity() {
        RecordFormats formats = Standard.LATEST_RECORD_FORMATS;
        ImportLogic.Monitor monitor = (ImportLogic.Monitor)Mockito.mock(ImportLogic.Monitor.class);
        Input.Estimates estimates = Inputs.knownEstimates((long)1000L, (long)1000L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
        new EstimationSanityChecker(formats, monitor).sanityCheck(estimates);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }
}

