/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Clock;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

class TimeCheckPointThreshold
extends AbstractCheckPointThreshold {
    private volatile long lastCheckPointedTransactionId;
    private volatile long nextCheckPointTime;
    private final long timeMillisThreshold;
    private final Clock clock;

    TimeCheckPointThreshold(long thresholdMillis, Clock clock) {
        super("time threshold");
        this.timeMillisThreshold = thresholdMillis;
        this.clock = clock;
        long randomStartOffset = thresholdMillis > 0L ? ThreadLocalRandom.current().nextLong(thresholdMillis) : 0L;
        this.nextCheckPointTime = clock.millis() + thresholdMillis + randomStartOffset;
    }

    @Override
    public void initialize(long transactionId) {
        this.lastCheckPointedTransactionId = transactionId;
    }

    @Override
    protected boolean thresholdReached(long lastCommittedTransactionId) {
        return lastCommittedTransactionId > this.lastCheckPointedTransactionId && this.clock.millis() >= this.nextCheckPointTime;
    }

    @Override
    public void checkPointHappened(long transactionId) {
        this.nextCheckPointTime = this.clock.millis() + this.timeMillisThreshold;
        this.lastCheckPointedTransactionId = transactionId;
    }

    @Override
    public long checkFrequencyMillis() {
        return this.timeMillisThreshold;
    }
}

