/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.HostnamePort;

class HostnamePortTest {
    HostnamePortTest() {
    }

    @Test
    void testHostnameOnly() {
        HostnamePort hostnamePort = new HostnamePort("myhost");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    void testHostnamePort() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1234");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1234}));
    }

    @Test
    void testHostnamePortRange() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1234-1243");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1243}));
    }

    @Test
    void testHostnamePortRangeInversed() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1243-1234");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1243));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1243, 1234}));
    }

    @Test
    void testSinglePortOnly() {
        HostnamePort hostnamePort = new HostnamePort(":1234");
        Assertions.assertNull((Object)hostnamePort.getHost());
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1234}));
    }

    @Test
    void testPortRangeOnly() {
        HostnamePort hostnamePort = new HostnamePort(":1230-1240");
        Assertions.assertNull((Object)hostnamePort.getHost());
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1230));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1230, 1240}));
    }

    @Test
    void testDefaultHost() {
        HostnamePort hostnamePort = new HostnamePort(":1234");
        MatcherAssert.assertThat((Object)hostnamePort.getHost("1.2.3.4"), (Matcher)CoreMatchers.equalTo((Object)"1.2.3.4"));
    }

    @Test
    void testGetHostAddress() throws Exception {
        String hostName = InetAddress.getLocalHost().getHostName();
        MatcherAssert.assertThat((Object)HostnamePort.getHostAddress(null, (String)"default"), (Matcher)CoreMatchers.equalTo((Object)"default"));
        MatcherAssert.assertThat((Object)HostnamePort.getHostAddress((String)hostName, (String)"default"), (Matcher)CoreMatchers.equalTo((Object)hostName));
    }

    @Test
    void testGetHostAddressUnknown() {
        String unknownHost = "unknownHost";
        Assertions.assertThrows(UnknownHostException.class, () -> InetAddress.getByName(unknownHost));
        MatcherAssert.assertThat((Object)HostnamePort.getHostAddress((String)unknownHost, (String)"default"), (Matcher)CoreMatchers.equalTo((Object)unknownHost));
    }

    @Test
    void testMatchesUnknownHosts() throws Exception {
        String knownHost = InetAddress.getLocalHost().getHostName();
        String unknownHost1 = "unknownHost1";
        String unknownHost2 = "unknownHost2";
        Assertions.assertThrows(UnknownHostException.class, () -> InetAddress.getByName(unknownHost1));
        Assertions.assertThrows(UnknownHostException.class, () -> InetAddress.getByName(unknownHost2));
        HostnamePort hostnamePortSinglePort = new HostnamePort(unknownHost1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(unknownHost1 + ":1234-1236");
        Assertions.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost1 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost1 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost1 + "")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost2 + "")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4:1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + knownHost + ":1234")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1234")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1235")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1236")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1233")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1237")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1)));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost2)));
    }

    @Test
    void testMatchesKnownHostWithIP() throws Exception {
        String[] host1Parts;
        String hostname1 = InetAddress.getLocalHost().getHostName().replace('.', '-');
        String host1 = InetAddress.getLocalHost().getHostAddress();
        StringBuilder host2 = new StringBuilder();
        for (String part : host1Parts = host1.split("\\.")) {
            int partnum = Integer.parseInt(part);
            host2.append(++partnum % 256 + ".");
        }
        host2.deleteCharAt(host2.length() - 1);
        HostnamePort hostnamePortSinglePort = new HostnamePort(hostname1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(hostname1 + ":1234-1236");
        Assertions.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname1 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname1 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1)));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2)));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1234")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1235")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1236")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1233")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1237")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1)));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2)));
    }

    @Test
    void testMatchesIPWithHost() throws Exception {
        String hostname1 = InetAddress.getLocalHost().getHostName();
        String host1 = InetAddress.getLocalHost().getHostAddress();
        String hostname2 = "neo4j.org";
        Assertions.assertDoesNotThrow(() -> InetAddress.getByName(hostname2));
        Assumptions.assumeFalse((boolean)hostname1.equals(hostname2));
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assertions.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1)));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname2)));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1234")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1235")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1236")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1233")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1237")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1)));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname2)));
    }

    @Test
    void testMatchesIPWithHostUnknown() throws Exception {
        String unknownHost = "unknownHost";
        Assertions.assertThrows(UnknownHostException.class, () -> InetAddress.getByName(unknownHost));
        String host1 = InetAddress.getLocalHost().getHostAddress();
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1236")));
    }

    @Test
    void testMatchesKnownHostWithHost() throws Exception {
        String host1 = InetAddress.getLocalHost().getHostName().replace('.', '-');
        String host2 = "neo4j.org";
        Assertions.assertDoesNotThrow(() -> InetAddress.getByName(host2));
        Assumptions.assumeFalse((boolean)host1.equals(host2));
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assertions.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1)));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2)));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1234")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1235")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1236")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1233")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1237")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1)));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2)));
    }

    @Test
    void testMatchesKnownHostWithHostUnknown() throws Exception {
        String host1 = InetAddress.getLocalHost().getHostName();
        String unknownHost = "unknownHost";
        Assertions.assertThrows(UnknownHostException.class, () -> InetAddress.getByName(unknownHost));
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1235")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1236")));
    }

    @Test
    void testMatchesIP() {
        HostnamePort hostnamePortSinglePort = new HostnamePort("1.2.3.4:1234");
        HostnamePort hostnamePortWithRange = new HostnamePort("1.2.3.4:1234-1236");
        Assertions.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4:1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4:1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://5.6.7.8:1234")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://5.6.7.8:1235")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4")));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://5.6.7.8")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1234")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1235")));
        Assertions.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1236")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://5.6.7.8:1234")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://5.6.7.8:1235")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1233")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1237")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4")));
        Assertions.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://5.6.7.8")));
    }

    @Test
    void testMatchesNullHostWithUnknownHost() {
        HostnamePort hostnamePortSinglePort = new HostnamePort(":1234");
        String unknownHost = "unknownHost";
        Assertions.assertThrows(UnknownHostException.class, () -> InetAddress.getByName(unknownHost));
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost + ":1234")));
    }

    @Test
    void testMatchesNullHostWithIP() throws Exception {
        HostnamePort hostnamePortSinglePort = new HostnamePort(":1234");
        String host1IP = InetAddress.getLocalHost().getHostAddress();
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1IP + ":1234")));
    }

    @Test
    void testMatchesNullHostWithKnownHost() throws Exception {
        HostnamePort hostnamePortSinglePort = new HostnamePort(":1234");
        String host1 = InetAddress.getLocalHost().getHostName();
        Assertions.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1234")));
    }

    @Test
    void testIPv6Address() {
        HostnamePort hostnamePort = new HostnamePort("[2001:cdba:0:0:0:0:3257:9652]");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[2001:cdba:0:0:0:0:3257:9652]"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    void testIPv6AddressWithSchemeAndPort() {
        HostnamePort hostnamePort = new HostnamePort("foo://[ff02::1:1]:9191");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[ff02::1:1]"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)9191));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{9191, 9191}));
    }

    @Test
    void testIPv6Localhost() {
        HostnamePort hostnamePort = new HostnamePort("[::1]");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[::1]"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    void testIPv6LocalhostWithSchemeAndPort() {
        HostnamePort hostnamePort = new HostnamePort("foo://[::1]:6362");
        MatcherAssert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[::1]"));
        MatcherAssert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)6362));
        MatcherAssert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{6362, 6362}));
    }
}

