/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.builtinprocs.IndexSpecifier;

public class IndexSpecifierTest {
    @Test
    public void shouldFormatAsCanonicalRepresentation() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)":Person(name)").toString(), (Matcher)Matchers.is((Object)":Person(name)"));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)":Person(name)").toString(), (Matcher)Matchers.is((Object)":Person(name)"));
    }

    @Test
    public void shouldParseASimpleLabel() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)":Person_23(name)").label(), (Matcher)Matchers.is((Object)"Person_23"));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)":Person_23(name)").label(), (Matcher)Matchers.is((Object)"Person_23"));
    }

    @Test
    public void shouldParseASimpleProperty() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)":Person(a_Name_123)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"a_Name_123"})));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)":Person(a_Name_123)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"a_Name_123"})));
    }

    @Test
    public void shouldParseTwoProperties() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)":Person(name, lastName)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"name", "lastName"})));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)":Person(name, lastName)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"name", "lastName"})));
    }

    @Test
    public void shouldParseManyProperties() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)":Person(1, 2, 3, 4, 5, 6)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2", "3", "4", "5", "6"})));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)":Person(1, 2, 3, 4, 5, 6)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2", "3", "4", "5", "6"})));
    }

    @Test
    public void shouldParseManyPropertiesWithWhitespace() {
        String specification = ":Person( 1 , 2   ,3   ,4  )";
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)specification).properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2", "3", "4"})));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)specification).properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2", "3", "4"})));
    }

    @Test
    public void shouldParseOddProperties() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)": Person(1,    2lskgj_LKHGS, `3sdlkhs,   df``sas;g`, 4, `  5  `, 6)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2lskgj_LKHGS", "3sdlkhs,   df``sas;g", "4", "  5  ", "6"})));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)": Person(1,    2lskgj_LKHGS, `3sdlkhs,   df``sas;g`, 4, `  5  `, 6)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2lskgj_LKHGS", "3sdlkhs,   df``sas;g", "4", "  5  ", "6"})));
    }

    @Test
    public void shouldParseANastyLabel() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)":`:(!\"\u00a3$%^&*( )`(name)").label(), (Matcher)Matchers.is((Object)":(!\"\u00a3$%^&*( )"));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)":`:(!\"\u00a3$%^&*( )`(name)").label(), (Matcher)Matchers.is((Object)":(!\"\u00a3$%^&*( )"));
    }

    @Test
    public void shouldParseANastyProperty() {
        MatcherAssert.assertThat((Object)IndexSpecifier.byPatternOrName((String)":Person(`(:!\"\u00a3$%^&*( )`)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"(:!\"\u00a3$%^&*( )"})));
        MatcherAssert.assertThat((Object)IndexSpecifier.byPattern((String)":Person(`(:!\"\u00a3$%^&*( )`)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"(:!\"\u00a3$%^&*( )"})));
    }

    @Test
    public void specifiersThatDoNotBeginWithColonAreIndexNames() {
        IndexSpecifier spec = IndexSpecifier.byPatternOrName((String)"my_index");
        MatcherAssert.assertThat((Object)spec.name(), (Matcher)Matchers.is((Object)"my_index"));
        Assert.assertNull((Object)spec.label());
        Assert.assertNull((Object)spec.properties());
        spec = IndexSpecifier.byName((String)"my_index");
        MatcherAssert.assertThat((Object)spec.name(), (Matcher)Matchers.is((Object)"my_index"));
        Assert.assertNull((Object)spec.label());
        Assert.assertNull((Object)spec.properties());
    }

    @Test
    public void patternSpecifiersHaveNoName() {
        IndexSpecifier spec = IndexSpecifier.byPattern((String)":Person(name)");
        Assert.assertNotNull((Object)spec.label());
        Assert.assertNotNull((Object)spec.properties());
        Assert.assertNull((Object)spec.name());
    }

    @Test
    public void shouldProduceAReasonableErrorIfTheSpecificationCantBeParsed() {
        try {
            IndexSpecifier.byPatternOrName((String)"just some rubbish");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IndexSpecifier.byPattern((String)"rubbish");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IndexSpecifier.byName((String)":Person(name)");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

