/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.api.state.PropertyContainerStateImpl;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.values.storable.Values;

public class PropertyContainerStateImplTest {
    @Test
    public void shouldListAddedProperties() {
        PropertyContainerStateImpl state = new PropertyContainerStateImpl(1L, OnHeapCollectionsFactory.INSTANCE);
        state.addProperty(1, Values.of((Object)"Hello"));
        state.addProperty(2, Values.of((Object)"Hello"));
        state.removeProperty(1);
        Iterator added = state.addedProperties();
        Assert.assertThat((Object)Iterators.asList((Iterator)added), (Matcher)CoreMatchers.equalTo(Arrays.asList(new PropertyKeyValue(2, Values.of((Object)"Hello")))));
    }

    @Test
    public void shouldListAddedPropertiesEvenIfPropertiesHaveBeenReplaced() {
        PropertyContainerStateImpl state = new PropertyContainerStateImpl(1L, OnHeapCollectionsFactory.INSTANCE);
        state.addProperty(1, Values.of((Object)"Hello"));
        state.addProperty(1, Values.of((Object)"WAT"));
        state.addProperty(2, Values.of((Object)"Hello"));
        Iterator added = state.addedProperties();
        Assert.assertThat((Object)Iterators.asList((Iterator)added), (Matcher)CoreMatchers.equalTo(Arrays.asList(new PropertyKeyValue(1, Values.of((Object)"WAT")), new PropertyKeyValue(2, Values.of((Object)"Hello")))));
    }

    @Test
    public void shouldConvertAddRemoveToChange() {
        PropertyContainerStateImpl state = new PropertyContainerStateImpl(1L, OnHeapCollectionsFactory.INSTANCE);
        state.removeProperty(4);
        state.addProperty(4, Values.of((Object)"another value"));
        Assert.assertThat((Object)Iterators.asList((Iterator)state.changedProperties()), (Matcher)CoreMatchers.equalTo(Arrays.asList(new PropertyKeyValue(4, Values.of((Object)"another value")))));
        Assert.assertFalse((boolean)state.addedProperties().hasNext());
        Assert.assertTrue((boolean)state.removedProperties().isEmpty());
    }
}

