/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.FileSystemIndexDropAction;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class GenericAccessorPointsTest {
    private static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    private static final ConfiguredSpaceFillingCurveSettingsCache configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults());
    private static final IndexSpecificSpaceFillingCurveSettingsCache indexSettings = new IndexSpecificSpaceFillingCurveSettingsCache(configuredSettings, new HashMap());
    private static final SpaceFillingCurve curve = indexSettings.forCrs(crs, true);
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fs.get());
    private final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withAccessChecks(true));
    private final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);
    private NativeIndexAccessor accessor;
    private StoreIndexDescriptor descriptor;

    @Before
    public void setup() {
        DefaultFileSystemAbstraction fs = (DefaultFileSystemAbstraction)this.fs.get();
        PageCache pc = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        File file = this.directory.file("index");
        GenericLayout layout = new GenericLayout(1, indexSettings);
        RecoveryCleanupWorkCollector collector = RecoveryCleanupWorkCollector.ignore();
        this.descriptor = TestIndexDescriptorFactory.forLabel(1, 1).withId(1L);
        IndexDirectoryStructure.Factory factory = IndexDirectoryStructure.directoriesByProvider((File)this.directory.storeDir());
        IndexDirectoryStructure structure = factory.forProvider(GenericNativeIndexProvider.DESCRIPTOR);
        FileSystemIndexDropAction dropAction = new FileSystemIndexDropAction((FileSystemAbstraction)fs, structure);
        this.accessor = new GenericNativeIndexAccessor(pc, (FileSystemAbstraction)fs, file, (IndexLayout)layout, collector, IndexProvider.Monitor.EMPTY, this.descriptor, indexSettings, (SpaceFillingCurveConfiguration)new StandardConfiguration(), (IndexDropAction)dropAction, false);
    }

    @After
    public void tearDown() {
        this.accessor.close();
    }

    @Test
    public void mustHandlePointsWithinSameTile() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Value> pointValues = new ArrayList<Value>();
        ArrayList updates = new ArrayList();
        long nodeId = 1L;
        for (int i = 0; i < nbrOfValues / 4; ++i) {
            double x1 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
            double x2 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
            double y1 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
            double y2 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
            PointValue value11 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y1});
            PointValue value12 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y2});
            PointValue value21 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y1});
            PointValue value22 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y2});
            this.assertDerivedValue(derivedValueForCenterPoint, value11, value12, value21, value22);
            nodeId = this.addPointsToLists(pointValues, updates, nodeId, value11, value12, value21, value22);
        }
        this.processAll(updates);
        this.exactMatchOnAllValues(pointValues);
    }

    @Test
    public void mustHandlePointArraysWithinSameTile() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Value> pointArrays = new ArrayList<Value>();
        ArrayList updates = new ArrayList();
        for (int i = 0; i < nbrOfValues; ++i) {
            int arrayLength = this.random.nextInt(5) + 1;
            PointValue[] pointValues = new PointValue[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                double x = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                double y = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x, centerPoint[1] + y});
                this.assertDerivedValue(derivedValueForCenterPoint, value);
                pointValues[j] = value;
            }
            PointArray array = Values.pointArray((PointValue[])pointValues);
            pointArrays.add((Value)array);
            updates.add(IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{array}));
        }
        this.processAll(updates);
        this.exactMatchOnAllValues(pointArrays);
    }

    @Test
    public void shouldNotGetRoundingErrorsWithPointsJustWithinTheTileUpperBound() {
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint);
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        double[] faultyCoords = new double[]{1.874410632171803E-8, 1.6763806281859016E-7};
        Assert.assertTrue((String)"inside upper x limit", (centerPoint[0] + xWidthMultiplier > faultyCoords[0] ? 1 : 0) != 0);
        Assert.assertTrue((String)"inside lower x limit", (centerPoint[0] - xWidthMultiplier < faultyCoords[0] ? 1 : 0) != 0);
        Assert.assertTrue((String)"inside upper y limit", (centerPoint[1] + yWidthMultiplier > faultyCoords[1] ? 1 : 0) != 0);
        Assert.assertTrue((String)"inside lower y limit", (centerPoint[1] - yWidthMultiplier < faultyCoords[1] ? 1 : 0) != 0);
        long derivedValueForFaultyCoords = curve.derivedValueFor(faultyCoords);
        Assertions.assertEquals((long)derivedValueForCenterPoint, (long)derivedValueForFaultyCoords, (String)"expected same derived value");
    }

    private long addPointsToLists(List<Value> pointValues, List<IndexEntryUpdate<?>> updates, long nodeId, PointValue ... values) {
        for (PointValue value : values) {
            pointValues.add((Value)value);
            updates.add(IndexEntryUpdate.add((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value}));
        }
        return nodeId;
    }

    private void assertDerivedValue(Long targetDerivedValue, PointValue ... values) {
        for (PointValue value : values) {
            Long derivedValueForValue = curve.derivedValueFor(value.coordinate());
            Assertions.assertEquals((Object)targetDerivedValue, (Object)derivedValueForValue, (String)"expected random value to belong to same tile as center point");
        }
    }

    private void processAll(List<IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
    }

    private void exactMatchOnAllValues(List<Value> values) throws IndexNotApplicableKernelException {
        try (IndexReader indexReader = this.accessor.newReader();){
            SimpleNodeValueClient client = new SimpleNodeValueClient();
            for (Value value : values) {
                IndexQuery.ExactPredicate exact = IndexQuery.exact((int)this.descriptor.schema().getPropertyId(), (Object)value);
                indexReader.query((IndexProgressor.NodeValueClient)client, IndexOrder.NONE, true, new IndexQuery[]{exact});
                Assert.assertTrue((boolean)client.next());
                Assertions.assertEquals((Object)value, (Object)client.values[0]);
                Assert.assertFalse((boolean)client.next());
            }
        }
    }
}

